/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;

public final class AlterDB
extends ACreate {
    private boolean closed;

    public AlterDB(String db, String name) {
        super(db, name);
    }

    @Override
    protected boolean run() {
        String src = this.args[0];
        String trg = this.args[1];
        if (!Databases.validName(src)) {
            return this.error(Text.NAME_INVALID_X, src);
        }
        if (!Databases.validName(trg)) {
            return this.error(Text.NAME_INVALID_X, trg);
        }
        if (!this.soptions.dbExists(src)) {
            return this.error(Text.DB_NOT_FOUND_X, src);
        }
        if (!this.closed) {
            this.closed = AlterDB.close(this.context, src);
        }
        if (this.context.pinned(src)) {
            return this.error(Text.DB_PINNED_X, src);
        }
        return AlterDB.alter(src, trg, this.soptions) && (!this.closed || new Open(trg).run(this.context)) ? this.info(Text.DB_RENAMED_X, src, trg) : this.error(Text.DB_NOT_RENAMED_X, src);
    }

    @Override
    public void addLocks() {
        this.jc().locks.writes.add(this.args[0]).add(this.args[1]);
    }

    public static synchronized boolean alter(String source, String target, StaticOptions sopts) {
        DropDB.drop(target, sopts);
        return sopts.dbPath(source).rename(sopts.dbPath(target));
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = AlterDB.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.ALTER + " " + Commands.CmdAlter.DB).args();
    }
}

