/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.data.DataText;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    protected final Builder builder;
    private final boolean stripNS;
    private final boolean stripWS;
    private final BoolList strips = new BoolList();
    private final Atts atts = new Atts();
    private final StringBuilder sb = new StringBuilder();
    private final Atts nsp = new Atts();
    private boolean dtd;
    int nodes;

    public SAXHandler(Builder builder) {
        this(builder, false, false);
    }

    public SAXHandler(Builder builder, boolean stripWS, boolean stripNS) {
        this.builder = builder;
        this.stripNS = stripNS;
        this.stripWS = stripWS;
        this.strips.push(stripWS);
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attr) throws SAXException {
        try {
            int a;
            this.finishText();
            int al = attr.getLength();
            for (int a2 = 0; a2 < al; ++a2) {
                this.atts.add(Token.token(attr.getQName(a2)), Token.token(attr.getValue(a2)), this.stripNS);
            }
            byte[] en = Token.token(name);
            this.builder.openElem(this.stripNS ? Token.local(en) : en, this.atts, this.nsp);
            boolean strip = this.strips.peek();
            if (this.stripWS && (a = this.atts.get(DataText.XML_SPACE)) != -1) {
                byte[] s = this.atts.value(a);
                if (Token.eq(s, DataText.DEFAULT)) {
                    strip = true;
                } else if (Token.eq(s, DataText.PRESERVE)) {
                    strip = false;
                }
            }
            this.strips.push(strip);
            this.atts.reset();
            this.nsp.reset();
            ++this.nodes;
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        try {
            this.finishText();
            this.builder.closeElem();
            this.strips.pop();
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.sb.append(chars, start, length);
    }

    @Override
    public void processingInstruction(String name, String content) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.pi(Token.token(name + " " + content));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void comment(char[] chars, int start, int length) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.comment(Token.token(new String(chars, start, length)));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    private void finishText() throws IOException {
        if (this.sb.length() != 0) {
            String s = this.sb.toString();
            this.builder.text(Token.token(this.strips.peek() ? s.trim() : s));
            this.sb.setLength(0);
        }
    }

    protected static void error(IOException ex) throws SAXException {
        SAXException ioe = new SAXException(Util.message(ex));
        ioe.setStackTrace(ex.getStackTrace());
        throw ioe;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.stripNS) {
            this.nsp.add(Token.token(prefix), Token.token(uri));
        }
    }

    @Override
    public void startDTD(String name, String pid, String sid) {
        this.dtd = true;
    }

    @Override
    public void endDTD() {
        this.dtd = false;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endEntity(String entity) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startEntity(String entity) {
    }

    static {
        System.setProperty("entityExpansionLimit", "536870912");
        System.setProperty("http.agent", "sax");
    }
}

