/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.Text;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.item.Str;
import org.basex.util.Atts;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class CsvBuilder
extends CsvConverter {
    private final Atts atts = new Atts();
    private final Atts nsp = new Atts();
    private final Builder builder;
    private int line;

    CsvBuilder(CsvParserOptions copts, Builder builder) throws IOException {
        super(copts);
        this.builder = builder;
        builder.openElem(Q_CSV.string(), this.atts, this.nsp);
    }

    @Override
    public void record() throws IOException {
        this.finishRecord();
        this.builder.openElem(Q_RECORD.string(), this.atts, this.nsp);
        this.column = -1;
        ++this.line;
    }

    @Override
    public void header(byte[] value) {
        this.headers.add(this.attributes ? value : XMLToken.encode(value, this.lax));
    }

    @Override
    public void entry(byte[] value) throws IOException {
        ++this.column;
        if (this.skipEmpty && value.length == 0) {
            return;
        }
        byte[] elem = Q_ENTRY.string();
        byte[] name = (byte[])this.headers.get(this.column);
        if (this.attributes) {
            if (name == null) {
                this.builder.openElem(elem, this.atts, this.nsp);
            } else {
                this.atts.add(Q_NAME.string(), name);
                this.builder.openElem(elem, this.atts, this.nsp);
                this.atts.reset();
            }
        } else {
            this.builder.openElem(name != null ? name : elem, this.atts, this.nsp);
        }
        this.builder.text(value);
        this.builder.closeElem();
    }

    @Override
    protected void init(String uri) {
    }

    @Override
    protected Str finish() throws IOException {
        this.finishRecord();
        this.builder.closeElem();
        return null;
    }

    @Override
    public String detailedInfo() {
        return Util.info(Text.LINE_X, this.line);
    }

    @Override
    public double progressInfo() {
        return (double)this.nli.size() / (double)this.nli.length();
    }

    private void finishRecord() throws IOException {
        if (this.column >= 0) {
            this.builder.closeElem();
        }
    }
}

