/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.Parser;
import org.basex.core.Text;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.jobs.Job;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.name.Names;
import org.basex.index.path.PathIndex;
import org.basex.index.resource.ResourceType;
import org.basex.index.stats.Stats;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Atts;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public abstract class Builder
extends Job {
    final PathIndex path = new PathIndex();
    final Namespaces nspaces = new Namespaces();
    final Parser parser;
    final String dbName;
    int ssize;
    int spos;
    MetaData meta;
    Names elemNames;
    Names attrNames;
    private final IntList parStack = new IntList();
    private final IntList elemStack = new IntList();
    private int level;
    private IOFile binariesDir;

    Builder(String dbName, Parser parser) {
        this.dbName = dbName;
        this.parser = parser;
    }

    final void parse() throws IOException {
        Performance perf = Prop.debug ? new Performance() : null;
        Util.debug(this.shortInfo() + "...", new Object[0]);
        try {
            this.parser.parse(this);
        }
        finally {
            this.parser.close();
        }
        this.meta.lastid = this.meta.size - 1;
        if (Prop.debug) {
            Util.errln(" " + perf + " (" + Performance.getMemory() + ")", new Object[0]);
        }
    }

    public final void binariesDir(IOFile dbpath) {
        if (dbpath != null) {
            this.binariesDir = ResourceType.BINARY.dir(dbpath);
        }
    }

    public final void openDoc(byte[] value) throws IOException {
        this.path.index(0, (byte)0, this.level);
        this.parStack.set(this.level++, this.meta.size);
        this.addDoc(value);
        this.nspaces.open();
    }

    public final void closeDoc() throws IOException {
        int pre = this.parStack.get(--this.level);
        this.setSize(pre, this.meta.size - pre);
        ++this.meta.ndocs;
        this.nspaces.close(this.meta.size);
        this.limit(this.elemNames.size(), 32768, "%: Too many distinct element names (limit: %).");
        this.limit(this.attrNames.size(), 32768, "%: Too many distinct attribute names (limit: %).");
        this.limit(this.nspaces.size(), 256, "%: Too many distinct namespaces (limit: %).");
        if (this.meta.size < 0) {
            this.limit(0, 0, "%: Input is too large for a single database.");
        }
    }

    public final void openElem(byte[] name, Atts att, Atts nsp) throws IOException {
        this.addElem(name, att, nsp);
        ++this.level;
    }

    public final void emptyElem(byte[] name, Atts att, Atts nsp) throws IOException {
        this.addElem(name, att, nsp);
        int pre = this.parStack.get(this.level);
        this.nspaces.close(pre);
        if (att.size() >= 31) {
            this.setSize(pre, this.meta.size - pre);
        }
    }

    public final void closeElem() throws IOException {
        this.checkStop();
        --this.level;
        int pre = this.parStack.get(this.level);
        this.setSize(pre, this.meta.size - pre);
        this.nspaces.close(pre);
    }

    public final void text(byte[] value) throws IOException {
        if (value.length != 0) {
            this.addText(value, (byte)2);
        }
    }

    public final void comment(byte[] value) throws IOException {
        this.addText(value, (byte)4);
    }

    public final void pi(byte[] pi) throws IOException {
        this.addText(pi, (byte)5);
    }

    public final void binary(String target, IO data) throws IOException {
        BinaryPut.put(data.inputSource(), new IOFile(this.binariesDir, target));
    }

    @Override
    public final String shortInfo() {
        return Text.CREATING_DB;
    }

    @Override
    public final String detailedInfo() {
        return this.spos == 0 ? this.parser.detailedInfo() : Text.FINISHING_D;
    }

    @Override
    public final double progressInfo() {
        return this.spos == 0 ? this.parser.progressInfo() : (double)this.spos / (double)this.ssize;
    }

    public abstract Data build() throws IOException;

    protected abstract void addDoc(byte[] var1) throws IOException;

    protected abstract void addElem(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    protected abstract void addAttr(int var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void addText(byte[] var1, int var2, byte var3) throws IOException;

    protected abstract void setSize(int var1, int var2) throws IOException;

    private void addElem(byte[] name, Atts atts, Atts nsp) throws IOException {
        int nameId = this.elemNames.index(name);
        this.path.index(nameId, (byte)1, this.level);
        int pre = this.meta.size;
        this.elemStack.set(this.level, nameId);
        this.parStack.set(this.level, pre);
        this.nspaces.open(pre, nsp);
        int dis = this.level == 0 ? 1 : pre - this.parStack.get(this.level - 1);
        int as = atts.size();
        byte[] prefix = Token.prefix(name);
        int uriId = this.nspaces.uriIdForPrefix(prefix, true);
        if (uriId == 0 && prefix.length != 0 && !Token.eq(prefix, Token.XML)) {
            throw new BuildException("%: Undeclared namespace prefix '%'.", this.parser.detailedInfo(), Token.prefix(name));
        }
        this.addElem(dis, nameId, Math.min(31, as + 1), uriId, !nsp.isEmpty());
        for (int a = 0; a < as; ++a) {
            byte[] an = atts.name(a);
            byte[] av = atts.value(a);
            byte[] ap = Token.prefix(an);
            nameId = this.attrNames.index(an, av);
            uriId = this.nspaces.uriIdForPrefix(ap, false);
            if (uriId == 0 && ap.length != 0 && !Token.eq(ap, Token.XML)) {
                throw new BuildException("%: Undeclared namespace prefix '%'.", this.parser.detailedInfo(), an);
            }
            this.path.index(nameId, (byte)3, this.level + 1, av, this.meta);
            this.addAttr(nameId, av, Math.min(31, a + 1), uriId);
        }
        if (this.level > 1) {
            this.elemNames.stats(this.elemStack.get(this.level - 1)).setLeaf(false);
        }
    }

    private void limit(int value, int limit, String message) throws IOException {
        if (value >= limit) {
            throw new BuildException(message, this.parser.detailedInfo(), limit);
        }
    }

    private void addText(byte[] value, byte kind) throws IOException {
        int l = this.level;
        if (l > 1) {
            Stats stats = this.elemNames.stats(this.elemStack.get(l - 1));
            if (kind == 2) {
                stats.add(value, this.meta);
            } else {
                stats.setLeaf(false);
            }
        }
        this.path.index(0, kind, l, value, this.meta);
        this.addText(value, l == 0 ? 1 : this.meta.size - this.parStack.get(l - 1), kind);
    }
}

