/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.client;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.api.client.ClientSession;
import org.basex.api.client.Query;
import org.basex.api.dom.BXNode;
import org.basex.core.BaseXException;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.Type;
import org.basex.server.ServerCmd;
import org.basex.util.TokenBuilder;

public class ClientQuery
extends Query {
    final ClientSession cs;
    final String id;

    ClientQuery(String query, ClientSession session, OutputStream output) throws IOException {
        this.cs = session;
        this.out = output;
        this.id = session.exec(ServerCmd.QUERY, query, null);
    }

    @Override
    public String info() throws IOException {
        return this.cs.exec(ServerCmd.INFO, this.id, null);
    }

    @Override
    public String options() throws IOException {
        return this.cs.exec(ServerCmd.OPTIONS, this.id, null);
    }

    @Override
    public boolean updating() throws IOException {
        return Boolean.parseBoolean(this.cs.exec(ServerCmd.UPDATING, this.id, null));
    }

    @Override
    public void bind(String name, Object value, String type) throws IOException {
        String v;
        String t;
        this.cache = null;
        Object vl = value instanceof BXNode ? ((BXNode)value).getNode() : value;
        String string = t = type == null ? "" : type;
        if (vl instanceof Value) {
            Value val = (Value)vl;
            Type tp = val.type;
            if (t.isEmpty()) {
                t = val.isEmpty() ? "empty-sequence()" : tp.toString();
            }
            try {
                TokenBuilder tb = new TokenBuilder();
                for (Item item : val) {
                    Type it;
                    if (!tb.isEmpty()) {
                        tb.addByte((byte)1);
                    }
                    if (item instanceof ANode) {
                        tb.add(item.serialize().finish());
                    } else {
                        tb.add(item.string(null));
                    }
                    if ((it = item.type) == tp) continue;
                    tb.addByte((byte)2).add(it);
                }
                v = tb.toString();
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        } else {
            v = value.toString();
        }
        ServerCmd cmd = name == null ? ServerCmd.CONTEXT : ServerCmd.BIND;
        Object n = name == null ? "" : name + "\u0000";
        this.cs.exec(cmd, this.id + "\u0000" + (String)n + v + "\u0000" + t, null);
    }

    @Override
    public void context(Object value, String type) throws IOException {
        this.bind(null, value, type);
    }

    @Override
    public String execute() throws IOException {
        return this.cs.exec(ServerCmd.EXEC, this.id, this.out);
    }

    @Override
    public void close() throws IOException {
        this.cs.exec(ServerCmd.CLOSE, this.id, null);
    }

    @Override
    public void cache(boolean full) throws IOException {
        this.cs.sout.write((full ? ServerCmd.FULL : ServerCmd.RESULTS).code);
        this.cs.send(this.id);
        this.cs.sout.flush();
        BufferInput bi = BufferInput.get(this.cs.sin);
        this.cache(bi, full);
        if (!ClientSession.ok(bi)) {
            throw new BaseXException(bi.readString(), new Object[0]);
        }
    }
}

