/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.in.TextInput;
import org.basex.util.Util;

final class WebDAVUtils {
    static final char SEP = '/';
    static final String DUMMY = ".empty";

    private WebDAVUtils() {
    }

    static String stripLeadingSlash(String s) {
        return s == null || s.isEmpty() || s.charAt(0) != '/' ? s : s.substring(1);
    }

    static String name(String path) {
        return IO.get((String)path).name();
    }

    static String dbName(String db) {
        return IO.get((String)db).dbName();
    }

    static String decode(String url) {
        if (url.indexOf(37) != -1) {
            try {
                String ud = URLDecoder.decode(url, StandardCharsets.UTF_8);
                return ud.contains("\ufffd") ? URLDecoder.decode(url, StandardCharsets.ISO_8859_1) : ud;
            }
            catch (Exception ex) {
                Util.stack((Throwable)ex);
            }
        }
        return url;
    }

    static int peek(BufferInput bi) throws IOException {
        TextInput ti = new TextInput((InputStream)bi);
        int c = ti.read();
        try {
            bi.reset();
        }
        catch (IOException ex) {
            Util.debug((Throwable)ex);
        }
        return c;
    }
}

