/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import java.util.Date;
import java.util.HashMap;
import org.basex.http.webdav.WebDAVLock;
import org.basex.http.webdav.WebDAVMetaData;

public final class WebDAVLocks {
    private static final WebDAVLocks INSTANCE = new WebDAVLocks();
    private final HashMap<String, WebDAVLock> locks = new HashMap();
    private long lockId;

    private WebDAVLocks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WebDAVLocks get() {
        WebDAVLocks webDAVLocks = INSTANCE;
        synchronized (webDAVLocks) {
            WebDAVLocks.INSTANCE.locks.entrySet().removeIf(entry -> ((WebDAVLock)entry.getValue()).token.isExpired());
            return INSTANCE;
        }
    }

    synchronized void unlock(String id) {
        this.locks.remove(id);
    }

    synchronized WebDAVLock refreshLock(String id) {
        WebDAVLock lock = this.locks.get(id);
        if (lock != null) {
            lock.token.setFrom(new Date());
        }
        return lock;
    }

    synchronized LockToken lockOn(WebDAVMetaData meta) {
        String path = meta.db + "/" + meta.path;
        for (WebDAVLock lock : this.locks.values()) {
            if (!path.startsWith(lock.path)) continue;
            return lock.token;
        }
        return null;
    }

    synchronized WebDAVLock create(LockTimeout timeout, LockInfo lockInfo, WebDAVMetaData meta) {
        LockToken token = new LockToken(Long.toString(this.lockId++), lockInfo, timeout);
        WebDAVLock lock = new WebDAVLock(token, meta.db + "/" + meta.path);
        this.locks.put(token.tokenId, lock);
        return lock;
    }

    synchronized boolean isLockedOut(WebDAVMetaData meta) {
        String path = meta.db + "/" + meta.path;
        for (WebDAVLock lock : this.locks.values()) {
            if (!lock.path.startsWith(path)) continue;
            return true;
        }
        return false;
    }
}

