/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.basex.query.expr.path.NameTest;
import org.basex.query.value.item.QNm;

final class RestXqError
implements Comparable<RestXqError> {
    private final ArrayList<NameTest> tests = new ArrayList(1);
    private static final Function<NameTest, Integer> COMPARE = test -> test == null ? -1 : test.part().ordinal();

    RestXqError() {
    }

    boolean add(NameTest test) {
        for (NameTest nt : this.tests) {
            if (!Objects.equals(nt, test)) continue;
            return false;
        }
        this.tests.add(test);
        return true;
    }

    NameTest get(int index) {
        return index < this.tests.size() ? this.tests.get(index) : null;
    }

    public boolean isEmpty() {
        return this.tests.isEmpty();
    }

    boolean matches(QNm name) {
        for (NameTest nt : this.tests) {
            if (nt != null && !nt.matches(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(RestXqError error) {
        return COMPARE.apply(error.tests.get(0)) - COMPARE.apply(this.tests.get(0));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (NameTest test : this.tests) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(test != null ? test : "*");
        }
        return sb.toString();
    }
}

