/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.list.ElementList;

public class LongList
extends ElementList {
    protected long[] list;

    public LongList() {
        this(8L);
    }

    public LongList(long capacity) {
        this.list = new long[Array.checkCapacity(capacity)];
    }

    public final LongList add(long element) {
        int s = this.size;
        long[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.size = s + 1;
        return this;
    }

    public final LongList add(long ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        long[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return this;
    }

    public final long get(int index) {
        return this.list[index];
    }

    public final long peek() {
        return this.list[this.size - 1];
    }

    public final long pop() {
        return this.list[--this.size];
    }

    public final void push(long element) {
        this.add(element);
    }

    public final long[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public long[] finish() {
        long[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public LongList sort() {
        int s = this.size;
        if (s > 1) {
            Arrays.sort(this.list, 0, s);
        }
        return this;
    }

    public LongList ddo() {
        if (!this.isEmpty()) {
            this.sort();
            int i = 1;
            for (int j = 1; j < this.size; ++j) {
                while (j < this.size && this.list[i - 1] == this.list[j]) {
                    ++j;
                }
                if (j >= this.size) continue;
                this.list[i++] = this.list[j];
            }
            this.size = i;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongList)) {
            return false;
        }
        LongList ll = (LongList)obj;
        if (this.size != ll.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == ll.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

