/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.list.ElementList;

public class FloatList
extends ElementList {
    protected float[] list;

    public FloatList() {
        this(8L);
    }

    public FloatList(long capacity) {
        this.list = new float[Array.checkCapacity(capacity)];
    }

    public final FloatList add(float element) {
        int s = this.size;
        float[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.size = s + 1;
        return this;
    }

    public final FloatList add(float ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        float[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return this;
    }

    public final float get(int index) {
        return this.list[index];
    }

    public final float[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public float[] finish() {
        float[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatList)) {
            return false;
        }
        FloatList dl = (FloatList)obj;
        if (this.size != dl.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == dl.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

