/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.EnumMap;
import java.util.Optional;
import org.basex.core.StaticOptions;
import org.basex.util.Base64;
import org.basex.util.Strings;
import org.basex.util.http.Client;
import org.basex.util.http.Request;
import org.basex.util.http.RequestAttribute;

public final class UserInfo {
    private final URI uri;
    private final Request request;
    private String username;
    private String password;

    public UserInfo(URI uri) {
        this(uri, null);
    }

    public UserInfo(URI uri, Request request) {
        this.uri = uri;
        this.request = request;
        String ui = uri.getUserInfo();
        if (ui != null) {
            String[] creds = Strings.split(ui, ':', 2);
            if (creds.length == 2) {
                this.username = creds[0];
                this.password = creds[1];
            }
        } else if (request != null) {
            this.username = request.attribute(RequestAttribute.USERNAME);
            this.password = request.attribute(RequestAttribute.PASSWORD);
        }
    }

    public void basic(HttpRequest.Builder rb) {
        if (this.username != null && this.password != null) {
            rb.header("Authorization", StaticOptions.AuthMethod.BASIC + " " + Base64.encode(this.username + ":" + this.password));
        }
    }

    public boolean assign(HttpRequest.Builder rb, HttpResponse<?> response) {
        Object value;
        if (this.username == null || this.password == null || response.statusCode() != 401) {
            return false;
        }
        if (this.request.authMethod == StaticOptions.AuthMethod.BASIC) {
            value = Base64.encode(this.username + ":" + this.password);
        } else {
            Optional<String> header = response.headers().firstValue("WWW-Authenticate");
            if (header.isEmpty()) {
                return false;
            }
            EnumMap<RequestAttribute, String> auth = Client.authHeaders(header.get());
            if (!auth.get((Object)RequestAttribute.AUTH_METHOD).equals(this.request.authMethod.toString())) {
                return false;
            }
            String realm = auth.get((Object)RequestAttribute.REALM);
            String nonce = auth.get((Object)RequestAttribute.NONCE);
            String qop = auth.get((Object)RequestAttribute.QOP);
            String nc = "00000001";
            String cnonce = Strings.md5(Long.toString(System.nanoTime()));
            String ha1 = Strings.md5(this.username + ":" + realm + ":" + this.password);
            String ha2 = Strings.md5(this.request.attribute(RequestAttribute.METHOD) + ":" + this.uri);
            String rsp = Strings.md5(ha1 + ":" + nonce + ":00000001:" + cnonce + ":" + qop + ":" + ha2);
            value = RequestAttribute.USERNAME + "=\"" + this.username + "\"," + RequestAttribute.REALM + "=\"" + realm + "\"," + RequestAttribute.NONCE + "=\"" + nonce + "\"," + RequestAttribute.URI + "=\"" + this.uri + "\"," + RequestAttribute.QOP + "=" + qop + "," + RequestAttribute.NC + "=00000001," + RequestAttribute.CNONCE + "=\"" + cnonce + "\"," + RequestAttribute.RESPONSE + "=\"" + rsp + "\"," + RequestAttribute.ALGORITHM + "=MD5," + RequestAttribute.OPAQUE + "=\"" + auth.get((Object)RequestAttribute.OPAQUE) + "\"";
        }
        rb.header("Authorization", this.request.authMethod + " " + (String)value);
        return true;
    }
}

