/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.StaticOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.http.HTTPText;
import org.basex.util.http.Part;
import org.basex.util.http.Request;
import org.basex.util.http.RequestAttribute;

public final class RequestParser {
    private final InputInfo info;

    public RequestParser(InputInfo info) {
        this.info = info;
    }

    public Request parse(ANode request, Value bodies) throws QueryException {
        Request hr = new Request();
        if (request != null) {
            for (ANode attr : request.attributeIter()) {
                String key = Token.string(attr.name());
                RequestAttribute r = RequestAttribute.get(key);
                if (r == null) {
                    throw QueryError.HC_REQ_X.get(this.info, "Unknown attribute: " + key);
                }
                hr.attributes.put(r, Token.string(attr.string()));
            }
            this.checkRequest(hr);
            ANode body = RequestParser.parseHeaders(request.childIter(), hr.headers);
            if (body != null) {
                QNm pl = body.qname();
                if (pl.eq(HTTPText.Q_HTTP_BODY)) {
                    this.parseBody(body, bodies, hr.payloadAtts, hr.payload);
                    hr.isMultipart = false;
                } else if (pl.eq(HTTPText.Q_HTTP_MULTIPART)) {
                    this.parseMultipart(body, bodies.iter(), hr.payloadAtts, hr.parts);
                    hr.isMultipart = true;
                } else {
                    throw QueryError.HC_REQ_X.get(this.info, "Unknown payload element: " + body.qname());
                }
            }
        }
        return hr;
    }

    private static void parseAtts(ANode element, Map<String, String> atts) {
        for (ANode attr : element.attributeIter()) {
            atts.put(Token.string(attr.name()), Token.string(attr.string()));
        }
    }

    private static ANode parseHeaders(BasicNodeIter iter, Map<String, String> headers) {
        for (ANode node : iter) {
            QNm nm = node.qname();
            if (nm == null) continue;
            if (!nm.eq(HTTPText.Q_HTTP_HEADER)) {
                return node;
            }
            String name = "";
            String value = "";
            for (ANode attr : node.attributeIter()) {
                QNm qn = attr.qname();
                if (qn.equals(HTTPText.Q_NAME)) {
                    name = Token.string(attr.string());
                    continue;
                }
                if (!qn.equals(HTTPText.Q_VALUE)) continue;
                value = Token.string(attr.string());
            }
            if (name.isEmpty() || value.isEmpty()) continue;
            headers.put(name, value);
        }
        return null;
    }

    private void parseBody(ANode body, Value items, Map<String, String> atts, ItemList payload) throws QueryException {
        block4: {
            RequestParser.parseAtts(body, atts);
            this.checkBody(body, atts);
            if (atts.get("src") != null) break block4;
            if (items.isEmpty()) {
                for (ANode node : body.childIter()) {
                    payload.add(node);
                }
            } else {
                for (Item item : items) {
                    payload.add(item);
                }
            }
        }
    }

    private void parseMultipart(ANode multipart, BasicIter<Item> bodies, HashMap<String, String> atts, ArrayList<Part> parts) throws QueryException {
        RequestParser.parseAtts(multipart, atts);
        if (atts.get(SerializerOptions.MEDIA_TYPE.name()) == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Attribute media-type of http:multipart is mandatory");
        }
        BasicNodeIter iter = multipart.childIter();
        while (true) {
            Part part = new Part();
            ANode payload = RequestParser.parseHeaders(iter, part.headers);
            if (payload == null) break;
            Item body = bodies.next();
            this.parseBody(payload, body == null ? Empty.VALUE : body, part.attributes, part.contents);
            parts.add(part);
        }
    }

    private void checkRequest(Request request) throws QueryException {
        String timeout;
        String mth = request.attribute(RequestAttribute.METHOD);
        if (mth == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Missing attribute: " + RequestAttribute.METHOD);
        }
        request.attributes.put(RequestAttribute.METHOD, mth.toUpperCase(Locale.ENGLISH));
        String us = request.attribute(RequestAttribute.USERNAME);
        if (us != null) {
            String pw = request.attribute(RequestAttribute.PASSWORD);
            if (pw == null) {
                throw QueryError.HC_REQ_X.get(this.info, "Missing attribute: " + RequestAttribute.PASSWORD);
            }
            String am = request.attribute(RequestAttribute.AUTH_METHOD);
            if (am != null) {
                StaticOptions.AuthMethod method = StaticOptions.AUTHMETHOD.get(am);
                if (method == null) {
                    throw QueryError.HC_REQ_X.get(this.info, "Invalid authentication method: " + am);
                }
                request.authMethod = method;
            }
        }
        if ((timeout = request.attribute(RequestAttribute.TIMEOUT)) != null && Strings.toInt(timeout) < 0) {
            throw QueryError.HC_REQ_X.get(this.info, "Invalid timeout: " + timeout);
        }
        for (RequestAttribute r : new RequestAttribute[]{RequestAttribute.FOLLOW_REDIRECT, RequestAttribute.STATUS_ONLY, RequestAttribute.SEND_AUTHORIZATION}) {
            String s = request.attribute(r);
            if (s == null || Strings.eq(s, "true", "false")) continue;
            throw QueryError.HC_REQ_X.get(this.info, "Value of '" + r + "' attribute is no boolean: " + s);
        }
    }

    private void checkBody(ANode body, Map<String, String> bodyAtts) throws QueryException {
        if (bodyAtts.get(SerializerOptions.MEDIA_TYPE.name()) == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Attribute media-type of http:body is mandatory");
        }
        if (bodyAtts.get("src") != null && (bodyAtts.size() > 2 || body.childIter().next() != null)) {
            throw QueryError.HC_ATTR.get(this.info, new Object[0]);
        }
    }
}

