/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import java.util.function.BiConsumer;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class ASet {
    protected int[] buckets;
    protected int[] next;
    protected int size = 1;

    protected ASet() {
    }

    protected ASet(long capacity) {
        long c;
        for (c = 1L; c < capacity; c <<= 1) {
        }
        int s = Array.checkCapacity(c);
        this.buckets = new int[s];
        this.next = new int[s];
    }

    protected void clear() {
        Arrays.fill(this.buckets, 0);
        this.size = 1;
    }

    public final int size() {
        return this.size - 1;
    }

    public final boolean isEmpty() {
        return this.size == 1;
    }

    protected final boolean checkCapacity() {
        return this.checkCapacity((id, bucket) -> {});
    }

    protected final boolean checkCapacity(BiConsumer<Integer, Integer> relocateAction) {
        if (this.size < this.capacity()) {
            return false;
        }
        int newSize = this.size << 1;
        int[] bckts = new int[newSize];
        int[] nArray = this.buckets;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int bucket;
            int id = bucket = nArray[i];
            while (id != 0) {
                int b = this.hash(id) & newSize - 1;
                int nx = this.next[id];
                relocateAction.accept(id, b);
                this.next[id] = bckts[b];
                bckts[b] = id;
                id = nx;
            }
        }
        this.buckets = bckts;
        this.next = Arrays.copyOf(this.next, newSize);
        this.rehash(newSize);
        return true;
    }

    protected final int capacity() {
        return this.next.length;
    }

    protected abstract int hash(int var1);

    protected abstract void rehash(int var1);

    public String toString(Object[] keys) {
        return this.toString(keys, null);
    }

    public String toString(Object[] keys, Object[] values) {
        TokenBuilder tb = new TokenBuilder().add(Util.className(this)).add(91);
        boolean more = false;
        for (int i = 1; i < this.size; ++i) {
            Object key = keys[i];
            if (key == null) continue;
            if (more) {
                tb.add(44);
            }
            tb.add(key);
            if (values != null) {
                tb.add(61).add(values[i]);
            }
            more = true;
        }
        return tb.add(93).toString();
    }
}

