/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class SnowballStemmer
extends Stemmer {
    private static final String PATTERN = "org.tartarus.snowball.ext.%Stemmer";
    private static final HashMap<Language, StemmerClass> CLASSES = new HashMap();
    private StemmerClass clazz;
    private Object stemmer;

    static boolean available() {
        return !CLASSES.isEmpty();
    }

    SnowballStemmer() {
    }

    private SnowballStemmer(Language lang, FTIterator fti) {
        super(fti);
        this.clazz = CLASSES.get(lang);
        this.stemmer = Reflect.get(this.clazz.clz);
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new SnowballStemmer(lang, fti);
    }

    @Override
    public boolean supports(Language lang) {
        return CLASSES.containsKey(lang);
    }

    @Override
    protected byte prec() {
        return 2;
    }

    @Override
    Collection<Language> languages() {
        return CLASSES.keySet();
    }

    @Override
    protected byte[] stem(byte[] word) {
        Reflect.invoke(this.clazz.setCurrent, this.stemmer, Token.string(word));
        Reflect.invoke(this.clazz.stem, this.stemmer, new Object[0]);
        String s = (String)Reflect.invoke(this.clazz.getCurrent, this.stemmer, new Object[0]);
        return s == null ? word : Token.token(s);
    }

    static {
        if (Reflect.available(PATTERN, "German")) {
            for (Language l : Language.ALL.values()) {
                Class<?> clz = Reflect.find(PATTERN, l);
                if (clz == null) continue;
                Method m1 = Reflect.method(clz, "setCurrent", String.class);
                Method m2 = Reflect.method(clz, "stem", new Class[0]);
                Method m3 = Reflect.method(clz, "getCurrent", new Class[0]);
                if (m1 == null || m2 == null || m3 == null) {
                    Util.debug("Could not initialize \"%\" Snowball stemmer.", l);
                    continue;
                }
                CLASSES.put(l, new StemmerClass(clz, m1, m2, m3));
            }
        }
    }

    private static class StemmerClass {
        final Class<?> clz;
        final Method setCurrent;
        final Method stem;
        final Method getCurrent;

        StemmerClass(Class<?> clz, Method setCurrent, Method stem, Method getCurrent) {
            this.clz = clz;
            this.setCurrent = setCurrent;
            this.stem = stem;
            this.getCurrent = getCurrent;
        }
    }
}

