/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class LuceneStemmer
extends Stemmer {
    private static final String PATTERN = "org.apache.lucene.analysis.%Stemmer";
    private static final HashMap<Language, StemmerClass> CLASSES = new HashMap();
    private StemmerClass clazz;
    private Object stemmer;

    private static void add(String ... lang) {
        for (String ln : lang) {
            Language l = Language.get(ln);
            if (l == null) continue;
            LuceneStemmer.add(l, l.code() + "." + l);
        }
    }

    private static void add(Language lang, String name) {
        boolean ch;
        Class<?> clz = Reflect.find(PATTERN, name);
        if (clz == null) {
            Util.debug("Could not initialize \"%\" Lucene stemmer class.", lang);
            return;
        }
        Method m = Reflect.method(clz, "stem", String.class);
        boolean bl = ch = m == null;
        if (ch) {
            m = Reflect.method(clz, "stem", char[].class, Integer.TYPE);
        }
        if (m == null) {
            Util.debug("Could not initialize \"%\" Lucene stemmer method.", lang);
        } else {
            CLASSES.put(lang, new StemmerClass(clz, m, ch));
        }
    }

    static boolean available() {
        return !CLASSES.isEmpty();
    }

    LuceneStemmer() {
    }

    private LuceneStemmer(Language lang, FTIterator fti) {
        super(fti);
        this.clazz = CLASSES.get(lang);
        this.stemmer = Reflect.get(this.clazz.clz);
    }

    @Override
    Collection<Language> languages() {
        return CLASSES.keySet();
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new LuceneStemmer(lang, fti);
    }

    @Override
    public boolean supports(Language lang) {
        return CLASSES.containsKey(lang);
    }

    @Override
    protected byte prec() {
        return 5;
    }

    @Override
    protected byte[] stem(byte[] word) {
        String s = Token.string(word);
        if (this.clazz.chars) {
            char[] ch = s.toCharArray();
            int cl = s.length();
            int nl = (Integer)Reflect.invoke(this.clazz.stem, this.stemmer, ch, cl);
            s = new String(ch, 0, nl);
        } else {
            s = (String)Reflect.invoke(this.clazz.stem, this.stemmer, s);
        }
        return s == null ? word : Token.token(s);
    }

    static {
        if (Reflect.available(PATTERN, "de.German")) {
            LuceneStemmer.add(Language.get("cs"), "cz.Czech");
            LuceneStemmer.add(Language.get("es"), "es.SpanishLight");
            LuceneStemmer.add(Language.get("fi"), "fi.FinnishLight");
            LuceneStemmer.add(Language.get("hu"), "hu.HungarianLight");
            LuceneStemmer.add(Language.get("it"), "it.ItalianLight");
            LuceneStemmer.add(Language.get("pt"), "br.Brazilian");
            LuceneStemmer.add(Language.get("sv"), "sv.SwedishLight");
            LuceneStemmer.add("ar", "bg", "de", "fr", "hi", "lv", "nl", "ru");
        }
    }

    private static class StemmerClass {
        final Class<?> clz;
        final Method stem;
        final boolean chars;

        StemmerClass(Class<?> clz, Method stem, boolean chars) {
            this.clz = clz;
            this.stem = stem;
            this.chars = chars;
            stem.setAccessible(true);
        }
    }
}

