/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Closure;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class VarScope {
    public final StaticContext sc;
    private final ArrayList<Var> vars = new ArrayList();

    public VarScope(StaticContext sc) {
        this.sc = sc;
    }

    public Var add(Var var) {
        var.slot = this.vars.size();
        this.vars.add(var);
        return var;
    }

    public Var addNew(QNm name, SeqType st, boolean param, QueryContext qc, InputInfo ii) {
        return this.add(new Var(name, st, qc, this.sc, ii, param));
    }

    public int enter(QueryContext qc) {
        return qc.stack.enterFrame(this.vars.size());
    }

    public static void exit(int fp, QueryContext qc) {
        qc.stack.exitFrame(fp);
    }

    public void cleanUp(Scope scope) {
        final BitSet declared = new BitSet();
        final BitSet used = new BitSet();
        scope.visit(new ASTVisitor(){

            @Override
            public boolean declared(Var var) {
                declared.set(var.id);
                return true;
            }

            @Override
            public boolean used(VarRef ref) {
                used.set(ref.var.id);
                return true;
            }
        });
        Iterator<Var> iter = this.vars.iterator();
        while (iter.hasNext()) {
            Var var = iter.next();
            if (declared.get(var.id)) continue;
            var.slot = -1;
            iter.remove();
        }
        if (scope instanceof Closure) {
            Iterator<Map.Entry<Var, Expr>> bindings = ((Closure)scope).globalBindings();
            while (bindings.hasNext()) {
                Var var = bindings.next().getKey();
                if (used.get(var.id)) continue;
                bindings.remove();
                var.slot = -1;
                this.vars.remove(var);
            }
        }
        int v = this.vars.size();
        while (--v >= 0) {
            this.vars.get((int)v).slot = v;
        }
    }

    public String toString() {
        return Util.className(this) + this.vars;
    }

    public int stackSize() {
        return this.vars.size();
    }

    public void copy(CompileContext cc, IntObjMap<Var> vm) {
        for (Var var : this.vars) {
            cc.copy(var, vm);
        }
    }
}

