/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.BigSeq;
import org.basex.query.value.seq.tree.TreeSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

public final class SmallSeq
extends TreeSeq {
    final Item[] items;

    SmallSeq(Item[] items, Type type) {
        super(items.length, type);
        this.items = items;
        assert (items.length >= 2 && items.length <= 7);
    }

    @Override
    public Item itemAt(long index) {
        return this.items[(int)index];
    }

    @Override
    public TreeSeq reverse(QueryContext qc) {
        int el = this.items.length;
        Item[] es = new Item[el];
        for (int e = 0; e < el; ++e) {
            es[e] = this.items[el - 1 - e];
        }
        return new SmallSeq(es, this.type);
    }

    @Override
    public TreeSeq insert(long pos, Item item, QueryContext qc) {
        int p = (int)pos;
        int n = this.items.length;
        Item[] out = new Item[n + 1];
        Array.copy(this.items, p, out);
        out[p] = item;
        Array.copy(this.items, p, n - p, out, p + 1);
        Type tp = this.type.union(item.type);
        return n < 7 ? new SmallSeq(out, tp) : new BigSeq(SmallSeq.slice(out, 0, 4), SmallSeq.slice(out, 4, n + 1), tp);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        int p = (int)pos;
        int n = this.items.length;
        if (n == 2) {
            return this.items[pos == 0L ? 1 : 0];
        }
        Item[] out = new Item[n - 1];
        Array.copy(this.items, p, out);
        Array.copy(this.items, p + 1, n - 1 - p, out, p);
        return new SmallSeq(out, this.type);
    }

    @Override
    protected Seq subSeq(long pos, long length, QueryContext qc) {
        int o = (int)pos;
        int l = (int)length;
        return new SmallSeq(SmallSeq.slice(this.items, o, o + l), this.type);
    }

    @Override
    public TreeSeq concat(TreeSeq other) {
        return other.prepend(this);
    }

    @Override
    public ListIterator<Item> iterator(final long start) {
        return new ListIterator<Item>(){
            private int index;
            {
                this.index = (int)start;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallSeq.this.items.length;
            }

            @Override
            public Item next() {
                return SmallSeq.this.items[this.index++];
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Item previous() {
                return SmallSeq.this.items[--this.index];
            }

            @Override
            public void set(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return SmallSeq.this.items[(int)i];
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public SmallSeq value(QueryContext qc, Expr expr) {
                return SmallSeq.this;
            }
        };
    }

    @Override
    TreeSeq prepend(SmallSeq seq) {
        Type tp = this.type.union(seq.type);
        Item[] itms = seq.items;
        int a = itms.length;
        int b = this.items.length;
        int n = a + b;
        if (Math.min(a, b) >= 4) {
            return new BigSeq(itms, this.items, tp);
        }
        Item[] out = new Item[n];
        Array.copy(itms, a, out);
        Array.copyFromStart(this.items, b, out, a);
        if (n <= 7) {
            return new SmallSeq(out, tp);
        }
        int mid = n / 2;
        return new BigSeq(SmallSeq.slice(out, 0, mid), SmallSeq.slice(out, mid, n), tp);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof SmallSeq ? Arrays.equals(this.items, ((SmallSeq)obj).items) : super.equals(obj));
    }
}

