/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.function.Predicate;
import org.basex.core.Store;
import org.basex.data.Data;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class SingletonSeq
extends Seq {
    private final Value value;

    private SingletonSeq(long size, Value value) {
        super(size, value.type);
        this.value = value;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        long count = in.readLong();
        Value value = Store.read(in, qc);
        return SingletonSeq.get(value, count);
    }

    @Override
    public void write(DataOutput out) throws IOException, QueryException {
        out.writeLong(this.count());
        Store.write(out, this.value);
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item head = this.value.itemAt(0L);
        if (head instanceof ANode) {
            return head;
        }
        throw QueryError.ebvError(this, ii);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.value.cache(lazy, ii);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return SingletonSeq.get(this.value.atomValue(qc, ii), this.size);
    }

    @Override
    protected Seq subSeq(long pos, long length, QueryContext qc) {
        return this.singleItem() ? new SingletonSeq(length, this.value) : super.subSeq(pos, length, qc);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return item.equals(this.value) ? SingletonSeq.get(this.value, this.size + 1L) : this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.singleItem() ? SingletonSeq.get(this.value, this.size - 1L) : this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        return this.singleItem() ? this : SingletonSeq.get(this.value.reverse(qc), this.count());
    }

    @Override
    public Item itemAt(long pos) {
        return this.value.itemAt(pos % this.value.size());
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (mode == CompileContext.Simplify.DISTINCT) {
            expr = this.value;
        } else if (this.type instanceof NodeType && mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING)) {
            expr = SingletonSeq.get((Value)this.value.simplifyFor(mode, cc), this.count());
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Value materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        return this.materialized(test, ii) ? this : new SingletonSeq(this.size, this.value.materialize(test, ii, qc));
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return this.value.materialized(test, ii);
    }

    @Override
    public String description() {
        return "singleton " + super.description();
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.REPLICATE, this.value, this.count());
    }

    public boolean singleItem() {
        return this.value.size() == 1L;
    }

    public long count() {
        return this.size / this.value.size();
    }

    public static Value get(Value value, long count) {
        if (count == 1L) {
            return value;
        }
        long vs = value.size();
        long size = vs * count;
        if (size == 0L) {
            return Empty.VALUE;
        }
        Value val = value;
        if (val instanceof SingletonSeq) {
            val = ((SingletonSeq)val).value;
        } else if (vs > 1L) {
            Item item = val.itemAt(0L);
            int v = 0;
            while ((long)(++v) < vs && item.equals(val.itemAt(v))) {
            }
            if ((long)v == vs) {
                val = item;
            }
        }
        return size == 1L ? val : new SingletonSeq(size, val);
    }
}

