/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.io.in.DataInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.seq.ShrSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public abstract class Seq
extends Value {
    protected long size;

    protected Seq(long size, Type type) {
        super(type);
        this.size = size;
    }

    @Override
    public Object toJava() throws QueryException {
        Object tp = this.type;
        if (tp == AtomType.ITEM) {
            tp = null;
            for (Item item : this) {
                Type st = item.type;
                tp = tp == null ? st : tp.union(st);
            }
        }
        int sz = (int)this.size;
        if (tp == AtomType.STRING) {
            StringList list = new StringList(sz);
            for (Item item : this) {
                list.add(item.string(null));
            }
            return list.finish();
        }
        Value value = Seq.get(sz, (Type)tp, this);
        if (value != null) {
            return value.toJava();
        }
        int a = 0;
        Object[] array = new Object[sz];
        for (Item item : this) {
            array[a++] = item.toJava();
        }
        return array;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.SEQFOUND_X.get(ii, this);
    }

    @Override
    public final Item test(QueryContext qc, InputInfo ii) throws QueryException {
        return this.ebv(qc, ii);
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return Seq.this.itemAt(i);
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public Seq value(QueryContext qc, Expr expr) {
                return Seq.this;
            }
        };
    }

    @Override
    public boolean ddo() {
        return false;
    }

    @Override
    public final Value subsequence(long start, long length, QueryContext qc) {
        return length == 0L ? Empty.VALUE : (length == 1L ? this.itemAt(start) : (length == this.size() ? this : this.subSeq(start, length, qc)));
    }

    protected Seq subSeq(long pos, long length, QueryContext qc) {
        qc.checkStop();
        return new SubSeq(this, pos, length);
    }

    public final Value insertBefore(long pos, Value value, QueryContext qc) {
        long n = value.size();
        return n == 0L ? this : (n == 1L ? this.insert(pos, (Item)value, qc) : this.copyInsert(pos, value, qc));
    }

    public abstract Value insert(long var1, Item var3, QueryContext var4);

    protected Value copyInsert(long pos, Value value, QueryContext qc) {
        long i;
        Type tp = this.type.union(value.type);
        if (pos == this.size) {
            return new TreeSeqBuilder().add(this, qc).add(value, qc).sequence(tp);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        vb.add(value);
        for (i = pos; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(tp);
    }

    public abstract Value remove(long var1, QueryContext var3);

    final Value copyRemove(long pos, QueryContext qc) {
        long i;
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        for (i = pos + 1L; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(this.type);
    }

    @Override
    public final void refineType(Expr expr) {
        Type t = expr.seqType().type.intersect(this.type);
        if (t != null) {
            this.type = t;
        }
    }

    @Override
    public final int hash(InputInfo ii) throws QueryException {
        int h = 1;
        long v = Math.min(this.size, 5L);
        while (--v >= 0L) {
            h = 31 * h + this.itemAt(v).hash(ii);
        }
        return h;
    }

    @Override
    public final SeqType seqType() {
        return this.type.seqType(Occ.ONE_OR_MORE);
    }

    @Override
    public boolean sameType() {
        for (Item item : this) {
            if (this.type.eq(item.type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item item : this) {
            vb.add(item.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (this.type instanceof NodeType && mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING)) {
            if (mode == CompileContext.Simplify.STRING) {
                TokenList list = new TokenList(this.size);
                int i = 0;
                while ((long)i < this.size) {
                    list.add(this.itemAt(i).string(null));
                    ++i;
                }
                expr = StrSeq.get(list);
            } else {
                Item[] items = new Item[(int)this.size];
                int i = 0;
                while ((long)i < this.size) {
                    items[i] = Atm.get(this.itemAt(i).string(null));
                    ++i;
                }
                expr = ItemSeq.get(items, (int)this.size, AtomType.UNTYPED_ATOMIC);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Item item : this) {
            item.cache(lazy, ii);
        }
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item head = this.itemAt(0L);
        if (head instanceof ANode) {
            return head;
        }
        throw QueryError.ebvError(this, ii);
    }

    @Override
    public Value materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item item : this) {
            qc.checkStop();
            vb.add((Item)item.materialize((Predicate)test, ii, qc));
        }
        return vb.value(this);
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        if (!this.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            for (Item item : this) {
                if (item.materialized(test, ii)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        Item item1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Seq s = (Seq)obj;
        if (this.size != s.size) {
            return false;
        }
        BasicIter<Item> iter1 = this.iter();
        BasicIter<Item> iter2 = s.iter();
        while ((item1 = iter1.next()) != null) {
            if (item1.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String description() {
        return this.type == AtomType.ITEM ? "sequence" : this.type + " sequence";
    }

    @Override
    public void toXml(QueryPlan plan) {
        int max = (int)Math.min(this.size, 5L);
        ExprList list = new ExprList(max);
        for (long i = 0L; i < (long)max; ++i) {
            list.add(this.itemAt(i));
        }
        plan.add(plan.create(this, new Object[0]), (ExprInfo[])list.finish());
    }

    @Override
    public final String toErrorString() {
        return this.build(true).toString();
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.build(false).finish());
    }

    private TokenBuilder build(boolean error) {
        TokenBuilder tb = new TokenBuilder().add(40);
        int i = 0;
        while ((long)i < this.size) {
            if (i > 0) {
                tb.add(", ");
            }
            tb.add(error ? this.itemAt(i).toErrorString() : this.itemAt(i).toString());
            if (tb.size() > 40 && (long)(i + 1) != this.size) {
                tb.add(", ").add("...");
                break;
            }
            ++i;
        }
        return tb.add(41);
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        throw Util.notExpected();
    }

    public static Value get(int size, Type type, Value ... values) throws QueryException {
        if (type instanceof AtomType) {
            switch ((AtomType)type) {
                case BOOLEAN: {
                    return BlnSeq.get(size, values);
                }
                case STRING: {
                    return StrSeq.get(size, values);
                }
                case BYTE: {
                    return BytSeq.get(size, values);
                }
                case SHORT: {
                    return ShrSeq.get(size, values);
                }
                case FLOAT: {
                    return FltSeq.get(size, values);
                }
                case DOUBLE: {
                    return DblSeq.get(size, values);
                }
                case DECIMAL: {
                    return DecSeq.get(size, values);
                }
                case UNSIGNED_LONG: {
                    return null;
                }
            }
            if (type.instanceOf(AtomType.INTEGER)) {
                return IntSeq.get(type, size, values);
            }
        }
        return null;
    }

    public static int initialCapacity(long size) throws QueryException {
        if (size > 0x7FFFFFF7L) {
            throw QueryError.ARRAY_X_X.get(null, 0x7FFFFFF7, size);
        }
        return Array.initialCapacity(size);
    }
}

