/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public final class ItemSeq
extends Seq {
    private final Item[] items;

    private ItemSeq(Item[] items, int size, Type type) {
        super(size, type);
        this.items = items;
    }

    @Override
    public Item itemAt(long pos) {
        return this.items[(int)pos];
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        Item[] tmp = new Item[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.items[i];
        }
        return new ItemSeq(tmp, sz, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof ItemSeq ? Array.equals(this.items, ((ItemSeq)obj).items) : super.equals(obj));
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.copyRemove(pos, qc);
    }

    public static Value get(Item[] items, int size, Type type) {
        return size == 0 ? Empty.VALUE : (size == 1 ? items[0] : new ItemSeq(items, size, type != null ? type : AtomType.ITEM));
    }
}

