/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.BoolList;

public final class BlnSeq
extends NativeSeq {
    public static final BlnSeq DISTINCT = new BlnSeq(new boolean[]{false, true});
    private final boolean[] values;

    private BlnSeq(boolean[] values) {
        super(values.length, (Type)AtomType.BOOLEAN);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        boolean[] values = new boolean[size];
        for (int s = 0; s < size; ++s) {
            values[s] = in.readBool();
        }
        return BlnSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (boolean v : this.values) {
            out.writeBool(v);
        }
    }

    @Override
    public Bln itemAt(long pos) {
        return Bln.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        boolean[] tmp = new boolean[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BlnSeq.get(tmp);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        BlnSeq expr = this;
        if (mode == CompileContext.Simplify.DISTINCT && this != DISTINCT) {
            boolean f = false;
            boolean t = false;
            for (boolean b : this.values) {
                if (b) {
                    t = true;
                } else {
                    f = true;
                }
                if (f && t) break;
            }
            expr = f ^ t ? Bln.get(t) : DISTINCT;
        }
        return cc.simplify(this, expr, mode);
    }

    public boolean[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof BlnSeq ? Arrays.equals(this.values, ((BlnSeq)obj).values) : super.equals(obj));
    }

    public static Value get(boolean[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Bln.get(values[0]) : new BlnSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        BoolList tmp = new BoolList(size);
        for (Value value : values) {
            if (value instanceof BlnSeq) {
                tmp.add(((BlnSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.bool(null));
            }
        }
        return BlnSeq.get(tmp.finish());
    }
}

