/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.ByteList;
import org.w3c.dom.DocumentFragment;

public final class FDoc
extends FNode {
    private final byte[] uri;
    private ANode[] children;

    private FDoc(byte[] uri) {
        super(NodeType.DOCUMENT_NODE);
        this.uri = uri;
    }

    public static FBuilder build(byte[] uri) {
        return new FBuilder(new FDoc(uri));
    }

    public static FBuilder build() {
        return FDoc.build(Token.EMPTY);
    }

    public static FBuilder build(String uri, DocumentFragment doc) {
        FBuilder builder = FDoc.build(Token.token(uri));
        FDoc.children(doc, builder, new TokenMap());
        return builder;
    }

    FDoc finish(ANode[] ch) {
        this.children = ch;
        return this;
    }

    @Override
    public byte[] string() {
        return FDoc.string(this.children);
    }

    @Override
    public BasicNodeIter childIter() {
        return ANodeList.iter(this.children);
    }

    @Override
    public boolean hasChildren() {
        return this.children.length != 0;
    }

    @Override
    public byte[] baseURI() {
        return this.uri;
    }

    @Override
    public FNode materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        FBuilder doc = FDoc.build(this.uri);
        for (ANode child : this.children) {
            doc.add((ANode)child.materialize((Predicate)test, ii, qc));
        }
        return doc.finish();
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.uri).add(0).finish();
    }

    @Override
    public Type.ID typeId() {
        return (this.children.length == 1 && this.children[0].type == NodeType.ELEMENT ? NodeType.DOCUMENT_NODE_ELEMENT : this.type).id();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FDoc)) {
            return false;
        }
        FDoc f = (FDoc)obj;
        return Arrays.equals(this.children, f.children) && Token.eq(this.uri, f.uri) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, QueryText.BASE, this.uri), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("document").brace(this.uri.length == 0 ? "..." : (Object)QueryString.toQuoted(this.uri));
    }
}

