/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.basex.core.Store;
import org.basex.data.Data;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.ExprList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQData;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class XQMap
extends XQData {
    private static final XQMap EMPTY = new XQMap(TrieNode.EMPTY, SeqType.MAP);
    static final int BITS = 5;
    private final TrieNode root;

    private XQMap(TrieNode root, Type type) {
        super(type);
        this.root = root;
    }

    public static XQMap empty() {
        return EMPTY;
    }

    public static XQMap entry(Item key, Value value, InputInfo ii) throws QueryException {
        return new XQMap(new TrieLeaf(key.hash(ii), key, value), MapType.get((AtomType)key.type, value.seqType()));
    }

    @Override
    public void write(DataOutput out) throws IOException, QueryException {
        out.writeNum(this.mapSize());
        for (Item key : this.keys()) {
            Store.write(out, key);
            Store.write(out, this.get(key, null));
        }
    }

    @Override
    public QNm paramName(int pos) {
        return new QNm("key", "");
    }

    @Override
    public void refineType(Expr expr) {
        if (this.root.size != 0) {
            super.refineType(expr);
        }
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.root.cache(lazy, ii);
    }

    public XQMap delete(Item key, InputInfo ii) throws QueryException {
        TrieNode del = this.root.delete(key.hash(ii), key, 0, ii);
        return del == this.root ? this : (del == null ? EMPTY : new XQMap(del, this.type));
    }

    @Override
    public Value get(Item key, InputInfo ii) throws QueryException {
        Value value = this.root.get(key.hash(ii), key, 0, ii);
        return value == null ? Empty.VALUE : value;
    }

    public boolean contains(Item key, InputInfo ii) throws QueryException {
        return this.root.contains(key.hash(ii), key, 0, ii);
    }

    public XQMap addAll(XQMap map, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        Type tp;
        if (this == EMPTY) {
            return map;
        }
        if (map == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(map.root, 0, merge, qc, ii);
        if (upd == map.root) {
            return map;
        }
        if (merge == MergeDuplicates.COMBINE) {
            MapType mt = (MapType)map.type;
            SeqType mst = mt.declType;
            tp = this.union(mt.keyType(), mst.zero() ? mst : mst.with(Occ.ONE_OR_MORE));
        } else {
            tp = this.type.union(map.type);
        }
        return new XQMap(upd, tp);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(ii, this);
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(ii, this);
    }

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        MapBuilder mb = new MapBuilder(ii);
        for (Item key : this.keys()) {
            qc.checkStop();
            mb.put(key, this.get(key, ii).materialize(test, ii, qc));
        }
        return mb.map();
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return this.funcType().declType.type.instanceOf(AtomType.ANY_ATOMIC_TYPE) || this.root.materialized(test, ii);
    }

    @Override
    public boolean instanceOf(Type tp) {
        SeqType dt;
        if (this.type.instanceOf(tp)) {
            return true;
        }
        if (!(tp instanceof FuncType) || tp instanceof ArrayType) {
            return false;
        }
        FuncType ft = (FuncType)tp;
        if (ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(SeqType.ANY_ATOMIC_TYPE_O)) {
            return false;
        }
        AtomType kt = null;
        if (ft instanceof MapType && (kt = ((MapType)ft).keyType()) == AtomType.ANY_ATOMIC_TYPE) {
            kt = null;
        }
        if ((dt = ft.declType).eq(SeqType.ITEM_ZM)) {
            dt = null;
        }
        return kt == null && dt == null || this.root.instanceOf(kt, dt);
    }

    public XQMap put(Item key, Value value, InputInfo ii) throws QueryException {
        if (this == EMPTY) {
            return XQMap.entry(key, value, ii);
        }
        TrieNode ins = this.root.put(key.hash(ii), key, value, 0, ii);
        return ins == this.root ? this : new XQMap(ins, this.union(key.type, value.seqType()));
    }

    private Type union(Type kt, SeqType vt) {
        MapType mt = (MapType)this.type;
        AtomType mkt = mt.keyType();
        SeqType mst = mt.declType;
        return mkt == kt && mst.eq(vt) ? this.type : MapType.get((AtomType)mkt.union(kt), mst.union(vt));
    }

    public int mapSize() {
        return this.root.size;
    }

    public Value keys() {
        ItemList items = new ItemList(this.root.size);
        this.root.keys(items);
        return items.value(((MapType)this.type).keyType());
    }

    public void values(ValueBuilder vb) {
        this.root.values(vb);
    }

    public void apply(QueryBiConsumer<Item, Value> func) throws QueryException {
        this.root.apply(func);
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        if (item instanceof FuncItem) {
            throw QueryError.FICOMPARE_X.get(deep.info, item);
        }
        return item instanceof XQMap && this.root.equal(((XQMap)item).root, deep);
    }

    @Override
    public HashMap<Object, Object> toJava() throws QueryException {
        HashMap<Object, Object> map = new HashMap<Object, Object>(this.root.size);
        this.apply((key, value) -> map.put(key.toJava(), value.toJava()));
        return map;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.root.hash(ii);
    }

    @Override
    public void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add("map{");
        int c = 0;
        IntConsumer addWS = lvl -> {
            for (int l = 0; l < lvl; ++l) {
                tb.add("  ");
            }
        };
        for (Item key : this.keys()) {
            Value value;
            boolean par;
            if (c++ > 0) {
                tb.add(44);
            }
            if (indent) {
                tb.add(10);
                addWS.accept(level + 1);
            }
            tb.add(key).add(58);
            if (indent) {
                tb.add(32);
            }
            boolean bl = par = (value = this.get(key, ii)).size() != 1L;
            if (par) {
                tb.add(40);
            }
            int cc = 0;
            for (Item item : value) {
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if (item instanceof XQMap) {
                    ((XQMap)item).string(indent, tb, level + 1, ii);
                    continue;
                }
                if (item instanceof XQArray) {
                    ((XQArray)item).string(indent, tb, level, ii);
                    continue;
                }
                tb.add(item);
            }
            if (!par) continue;
            tb.add(41);
        }
        if (indent) {
            tb.add(10);
            addWS.accept(level);
        }
        tb.add(125);
    }

    @Override
    public String description() {
        return "map";
    }

    @Override
    public void toXml(QueryPlan plan) {
        try {
            int size = this.mapSize();
            Value keys = this.keys();
            ExprList list = new ExprList();
            int max = Math.min(size, 5);
            for (long i = 0L; i < (long)max; ++i) {
                Item key = keys.itemAt(i);
                ((ExprList)((Object)list.add(key))).add(this.get(key, null));
            }
            plan.add(plan.create(this, "entries", size), new ExprInfo[0]);
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("map").brace(this.root.append(new StringBuilder()).toString().replaceAll(", $", ""));
    }
}

