/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class MapBuilder {
    private final InputInfo info;
    private XQMap map = XQMap.empty();

    public MapBuilder() {
        this(null);
    }

    public MapBuilder(InputInfo info) {
        this.info = info;
    }

    public MapBuilder put(Item key, Value value) throws QueryException {
        this.map = this.map.put(key, value, this.info);
        return this;
    }

    public MapBuilder put(String key, Value value) throws QueryException {
        return this.put(Str.get(key), value);
    }

    public MapBuilder put(String key, byte[] value) throws QueryException {
        return this.put(key, (Value)(value != null ? Str.get(value) : Empty.VALUE));
    }

    public MapBuilder put(String key, String value) throws QueryException {
        return this.put(key, (Value)(value != null ? Str.get(value) : Empty.VALUE));
    }

    public boolean contains(Item key) throws QueryException {
        return this.map.contains(key, this.info);
    }

    public Value get(Item key) throws QueryException {
        return this.map.get(key, this.info);
    }

    public XQMap map() {
        XQMap m = this.map;
        this.map = null;
        return m;
    }
}

