/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Int
extends ANum {
    public static final Int MAX;
    public static final Int ZERO;
    public static final Int ONE;
    private static final Int[] INTSS;
    private final long value;

    private Int(long value) {
        this(value, AtomType.INTEGER);
    }

    public Int(long value, Type type) {
        super(type);
        this.value = value;
    }

    public static Int get(long value) {
        return value >= 0L && value < (long)INTSS.length ? INTSS[(int)value] : new Int(value);
    }

    public static Int get(long value, Type type) {
        return type == AtomType.INTEGER ? Int.get(value) : new Int(value, type);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public byte[] string() {
        return this.value == 0L ? Token.ZERO : Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value != 0L;
    }

    @Override
    public long itr() {
        return this.value;
    }

    @Override
    public float flt() {
        return this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public Item test(QueryContext qc, InputInfo ii) {
        return this.value == qc.focus.pos ? this : null;
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Int abs() {
        return this.value < 0L ? Int.get(-this.value) : this;
    }

    @Override
    public Int ceiling() {
        return this;
    }

    @Override
    public Int floor() {
        return this;
    }

    @Override
    public ANum round(int scale, boolean even) {
        long v = this.rnd(scale, even);
        return v == this.value ? this : Int.get(v);
    }

    private long rnd(int s, boolean e) {
        long v = this.value;
        if (s >= 0 || v == 0L) {
            return v;
        }
        if (s < -15) {
            return Dec.get(new BigDecimal(v)).round(s, e).itr();
        }
        long f = 1L;
        int c = -s;
        for (long i = 0L; i < (long)c; ++i) {
            f = (f << 3) + (f << 1);
        }
        boolean n = v < 0L;
        long a = n ? -v : v;
        long m = a % f;
        long d = m << 1;
        v = a - m;
        if (e ? d > f || d == f && v % (f << 1) != 0L : (n ? d > f : d >= f)) {
            v += f;
        }
        return n ? -v : v;
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return item instanceof Int ? this.value == ((Int)item).value : (item instanceof Dec ? item.eq(this, coll, sc, ii) : (double)this.value == item.dbl(ii));
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        if (item instanceof Int) {
            return Long.compare(this.value, ((Int)item).value);
        }
        if (item.type == AtomType.DECIMAL) {
            return -item.diff(this, coll, ii);
        }
        double d = item.dbl(ii);
        return Double.isNaN(d) ? Integer.MIN_VALUE : ((double)this.value < d ? -1 : ((double)this.value > d ? 1 : 0));
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYTE: {
                return (byte)this.value;
            }
            case SHORT: 
            case UNSIGNED_BYTE: {
                return (short)this.value;
            }
            case UNSIGNED_SHORT: {
                return Character.valueOf((char)this.value);
            }
            case INT: {
                return (int)this.value;
            }
        }
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Int)) {
            return false;
        }
        Int i = (Int)obj;
        return this.type == i.type && this.value == i.value;
    }

    public static long parse(byte[] value, InputInfo ii) throws QueryException {
        long l = Token.toLong(value);
        if (l != Long.MIN_VALUE || Token.eq(Token.trim(value), Token.MIN_LONG)) {
            return l;
        }
        throw AtomType.INTEGER.castError(value, ii);
    }

    static {
        int nl = 128;
        INTSS = new Int[128];
        for (int n = 0; n < 128; ++n) {
            Int.INTSS[n] = new Int(n);
        }
        MAX = Int.get(Long.MAX_VALUE);
        ZERO = INTSS[0];
        ONE = INTSS[1];
    }
}

