/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.util.regex.parse.RegExParserConstants;
import org.basex.query.util.regex.parse.Token;
import org.basex.query.util.regex.parse.TokenManager;
import org.basex.query.util.regex.parse.TokenMgrError;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public class RegExLexer
implements TokenManager,
RegExParserConstants {
    private static final Token EOF_TOKEN = new Token(0);
    private final byte[] input;
    private int pos;
    private final IntList lines;
    private int state;
    private byte first;
    private final TokenBuilder tb = new TokenBuilder();
    private Object payload;
    private final boolean skipWs;
    private static final Pattern CAT_REGEX = Pattern.compile("^L[ultmo]?|M[nce]?|N[dlo]?|P[cdseifo]?|Z[slp]?|S[mcko]?|C[cfon]?|Is[a-zA-Z\\d\\-]+$");

    public RegExLexer(byte[] input, boolean strip) {
        this.input = input;
        IntList ls = null;
        int il = input.length;
        for (int i = 0; i < il; ++i) {
            byte c = input[i];
            if (c != 13 && c != 10) continue;
            if (c == 13 && ++i < il && input[i] == 10) {
                ++i;
            }
            if (i >= il) continue;
            if (ls == null) {
                ls = new IntList();
            }
            ls.add(i);
        }
        this.lines = ls;
        this.skipWs = strip;
    }

    private int next() {
        int cp;
        int il = this.input.length;
        do {
            if (this.pos >= il) {
                return -1;
            }
            cp = org.basex.util.Token.cp(this.input, this.pos);
            this.pos += org.basex.util.Token.cl(this.input, this.pos);
        } while (this.skipWs && this.state <= 0 && org.basex.util.Token.ws(cp));
        this.tb.add(cp);
        return cp;
    }

    private int normal() {
        int curr = this.next();
        if (curr == -1) {
            return 0;
        }
        switch (curr) {
            case 94: {
                return 16;
            }
            case 36: {
                return 17;
            }
            case 63: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 43: {
                return 4;
            }
            case 46: {
                return 15;
            }
            case 124: {
                return 1;
            }
            case 40: {
                int p = this.pos;
                int ts = this.tb.size();
                if (this.next() == 63 && this.next() == 58) {
                    return 9;
                }
                this.pos = p;
                this.tb.size(ts);
                return 11;
            }
            case 41: {
                return 10;
            }
            case 123: {
                this.state = -1;
                return 5;
            }
            case 92: {
                return this.escape();
            }
            case 91: {
                ++this.state;
                this.first = 1;
                return 21;
            }
            case 93: 
            case 125: {
                throw this.error("", curr);
            }
        }
        if (curr >= 48 && curr <= 57) {
            return 13;
        }
        return 12;
    }

    private int escape() {
        int curr = this.next();
        switch (curr) {
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 110: 
            case 114: 
            case 116: 
            case 123: 
            case 124: 
            case 125: {
                return 18;
            }
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 87: 
            case 99: 
            case 100: 
            case 105: 
            case 115: 
            case 119: {
                return 19;
            }
            case 80: 
            case 112: {
                String p = "\\" + (char)curr;
                int nxt = this.next();
                if (nxt != 123) {
                    throw this.error(p, nxt);
                }
                int cp = this.next();
                while (cp != 125) {
                    if (cp == -1) {
                        throw this.error(this.tb.toString(), -1);
                    }
                    cp = this.next();
                }
                String in = this.tb.toString().substring(3, this.tb.size() - 1);
                Matcher m = CAT_REGEX.matcher(in);
                if (!m.matches()) {
                    throw this.error("{", nxt);
                }
                this.payload = in;
                return 20;
            }
        }
        if (curr < 48 || curr > 57) {
            throw this.error("\\", (char)curr);
        }
        return 14;
    }

    private TokenMgrError error(String before, int curr) {
        int[] lc = this.lineCol(this.pos);
        return new TokenMgrError(curr < 0, this.state, lc[1], lc[3], before, (char)curr, 0);
    }

    private int inClass() {
        byte fst = this.first;
        this.first = 0;
        int curr = this.next();
        switch (curr) {
            case 92: {
                return this.escape();
            }
            case 94: {
                if (fst == 1) {
                    this.first = (byte)-1;
                    return 22;
                }
                return 12;
            }
            case 91: {
                ++this.state;
                this.first = 1;
                return 21;
            }
            case 93: {
                --this.state;
                return 24;
            }
            case 45: {
                return this.pos < this.input.length && this.input[this.pos] == 91 ? 23 : 12;
            }
        }
        return 12;
    }

    private int inQuantifier() {
        byte b;
        int curr = this.next();
        if (curr == 44) {
            return 8;
        }
        if (curr == 125) {
            this.state = 0;
            return 6;
        }
        if (curr < 48 || curr > 57) {
            throw this.error("{", curr);
        }
        int il = this.input.length;
        while (this.pos < il && (b = this.input[this.pos]) >= 48 && b <= 57) {
            this.tb.add(b);
            ++this.pos;
        }
        this.payload = this.tb.toString();
        return 7;
    }

    private int[] lineCol(int start) {
        int[] lc = new int[4];
        if (this.lines != null) {
            int ls = this.lines.size();
            int ln = 0;
            int st = 0;
            for (int i = 0; i < 2; ++i) {
                int curr;
                int n = curr = i == 0 ? start : this.pos;
                while (ln < ls && this.lines.get(ln) < curr) {
                    st = this.lines.get(ln);
                    ++ln;
                }
                lc[i] = ln + 1;
                lc[i + 2] = curr - st + 1;
            }
        } else {
            lc[1] = 1;
            lc[0] = 1;
            lc[2] = start;
            lc[3] = this.pos;
        }
        return lc;
    }

    @Override
    public Token getNextToken() {
        if (this.pos >= this.input.length) {
            return EOF_TOKEN;
        }
        int start = this.pos;
        this.payload = null;
        int type = this.state > 0 ? this.inClass() : (this.state < 0 ? this.inQuantifier() : this.normal());
        RegExToken tok = new RegExToken(type, start, this.tb.toString());
        this.tb.size(0);
        return tok;
    }

    class RegExToken
    extends Token {
        private final Object obj;

        RegExToken(int k, int start, String img) {
            this.obj = RegExLexer.this.payload;
            this.kind = k;
            this.image = img;
            int[] lc = RegExLexer.this.lineCol(start);
            this.beginLine = lc[0];
            this.endLine = lc[1];
            this.beginColumn = lc[2];
            this.endColumn = lc[3];
        }

        @Override
        public Object getValue() {
            return this.obj;
        }
    }
}

