/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex.parse;

import org.basex.query.util.regex.parse.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token curr, int[][] exps, String[] imgs) {
        super(ParseException.initialise(curr, exps, imgs));
        this.currentToken = curr;
        this.expectedTokenSequences = exps;
        this.tokenImage = imgs;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token curr, int[][] exps, String[] img) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int[] exp : exps) {
            if (maxSize < exp.length) {
                maxSize = exp.length;
            }
            for (int ex : exp) {
                expected.append(img[ex]).append(' ');
            }
            if (exp[exp.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
        }
        Object retval = "Encountered \"";
        Token tok = curr.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = (String)retval + " ";
            }
            if (tok.kind == 0) {
                retval = (String)retval + img[0];
                break;
            }
            retval = (String)retval + " " + img[tok.kind];
            retval = (String)retval + " \"";
            retval = (String)retval + ParseException.addEscapes(tok.image);
            retval = (String)retval + " \"";
            tok = tok.next;
        }
        retval = (String)retval + "\" at line " + curr.next.beginLine + ", column " + curr.next.beginColumn;
        retval = (String)retval + "." + eol;
        retval = exps.length == 1 ? (String)retval + "Was expecting:" + eol + "    " : (String)retval + "Was expecting one of:" + eol + "    ";
        retval = (String)retval + expected.toString();
        return retval;
    }

    static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

