/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;

final class FormatterFR
extends Formatter {
    private static final byte[][] WORDS = Token.tokens("z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf");
    private static final byte[][] WORDS20 = Token.tokens("", "", "vingt", "trente", "quarante", "cinquante", "soixante", "", "quatre-vingt");
    private static final byte[][] WORDS1000000 = Token.tokens("million", "milliard", "billion", "billiard", "trillion");
    private static final byte[] ORDINAL = Token.token("i\u00e8me");
    private static final long[] UNITS100 = new long[]{1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] DAYS = Token.tokens("Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche");
    private static final byte[][] MONTHS = Token.tokens("Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre");
    private static final byte[][] AMPM = Token.tokens("a.m.", "p.m.");
    private static final byte[][] ERAS = Token.tokens("av. J.-C.", "ap. J.-C.");

    FormatterFR() {
    }

    @Override
    public byte[] word(long n, byte[] ordinal) {
        TokenBuilder tb = new TokenBuilder();
        FormatterFR.word(tb, n, ordinal, true);
        TokenParser tp = new TokenParser(tb.next());
        boolean u = true;
        while (tp.more()) {
            tb.add(u ? Token.uc(tp.next()) : Token.lc(tp.next()));
            u = false;
        }
        return tb.finish();
    }

    @Override
    public byte[] ordinal(long n, byte[] ordinal) {
        return Token.EMPTY;
    }

    @Override
    public byte[] month(int n, int min, int max) {
        return FormatterFR.format(MONTHS[n], min, max);
    }

    @Override
    public byte[] day(int n, int min, int max) {
        return FormatterFR.format(DAYS[n], min, max);
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(long year) {
        return ERAS[year <= 0L ? 0 : 1];
    }

    private static void word(TokenBuilder tb, long n, byte[] ordinal, boolean last) {
        if (n == 0L && !tb.isEmpty()) {
            if (ordinal != null) {
                tb.add(ORDINAL).add(ordinal);
            }
        } else if (n < 20L) {
            if (ordinal == null) {
                tb.add(WORDS[(int)n]);
            } else if (n == 1L) {
                tb.add(tb.isEmpty() ? "premier" : "uni\u00e8me");
            } else {
                FormatterFR.ordinal(ordinal, tb.add(WORDS[(int)n]));
            }
        } else if (n < 60L) {
            int r = (int)(n % 10L);
            tb.add(WORDS20[(int)n / 10]);
            if (r == 1) {
                tb.add(" et un");
            } else if (r > 1) {
                tb.add(45).add(WORDS[r]);
            }
            FormatterFR.ordinal(ordinal, tb);
        } else if (n < 80L) {
            tb.add(WORDS20[6]);
            int r = (int)(n % 20L);
            if (r == 1) {
                tb.add(" et un");
            } else if (r == 11) {
                tb.add(" et onze");
            } else if (r > 1) {
                tb.add(45).add(WORDS[r]);
            }
            FormatterFR.ordinal(ordinal, tb);
        } else if (n < 100L) {
            tb.add(WORDS20[8]);
            int r = (int)(n % 20L);
            if (r > 0) {
                tb.add(45).add(WORDS[r]);
            } else if (ordinal == null && last) {
                tb.add("s");
            }
            FormatterFR.ordinal(ordinal, tb);
        } else if (n < 1000L) {
            if (n >= 200L) {
                FormatterFR.word(tb, n / 100L, null, false);
                tb.add(32);
            }
            tb.add("cent");
            int r = (int)(n % 100L);
            if (r != 0) {
                tb.add(32);
            } else if (n > 100L && ordinal == null && last) {
                tb.add(115);
            }
            if (r == 1 && ordinal != null) {
                FormatterFR.ordinal(ordinal, tb.add(WORDS[1]));
            } else {
                FormatterFR.word(tb, n % 100L, ordinal, last);
            }
        } else if (n < 1000000L) {
            if (n >= 2000L) {
                FormatterFR.word(tb, n / 1000L, null, false);
                tb.add(32);
            }
            int r = (int)(n % 1000L);
            tb.add(ordinal != null && r == 0 ? "mill" : "mille");
            if (r != 0) {
                tb.add(32);
            }
            FormatterFR.word(tb, n % 1000L, ordinal, last);
        } else {
            int w = WORDS1000000.length;
            while (--w > 0 && n < UNITS100[w]) {
            }
            long f = UNITS100[w];
            long i = n / f;
            if (i != 1L) {
                FormatterFR.word(tb, i, null, true);
                tb.add(32);
            } else if (ordinal == null) {
                tb.add("un ");
            }
            tb.add(WORDS1000000[w]);
            long r = n % f;
            if (ordinal != null && r == 0L) {
                tb.add(ORDINAL).add(ordinal);
            } else if (i > 1L && ordinal == null) {
                tb.add("s");
            }
            if (r != 0L) {
                tb.add(32);
                FormatterFR.word(tb, r, ordinal, last);
            }
        }
    }

    private static void ordinal(byte[] ordinal, TokenBuilder tb) {
        if (ordinal != null) {
            int l = tb.size() - 1;
            byte c = tb.get(l);
            if (c == 101) {
                tb.delete(l, l + 1);
            } else if (c == 102) {
                tb.set(l, (byte)118);
            } else if (c == 113) {
                tb.add(117);
            }
            tb.add(ORDINAL).add(ordinal);
        }
    }
}

