/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.format.DateFormat;
import org.basex.query.util.format.DateParser;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.util.format.FormatterDE;
import org.basex.query.util.format.FormatterEN;
import org.basex.query.util.format.FormatterFR;
import org.basex.query.util.format.IntFormat;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public abstract class Formatter
extends FormatUtil {
    private static final byte[] MIL = Token.token("YXWVUTSRQPONZABCDEFGHIKLM");
    private static final byte[] N = new byte[]{110};
    private static final byte[][] CALENDARS = Token.tokens("ISO", "AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS");
    public static final byte[] EN = Token.token("en");
    private static final TokenObjMap<Formatter> MAP = new TokenObjMap();

    public static Formatter get(byte[] language) {
        Formatter form = MAP.get(language);
        return form != null ? form : MAP.get(EN);
    }

    protected abstract byte[] word(long var1, byte[] var3);

    protected abstract byte[] ordinal(long var1, byte[] var3);

    protected abstract byte[] month(int var1, int var2, int var3);

    protected abstract byte[] day(int var1, int var2, int var3);

    protected abstract byte[] ampm(boolean var1);

    protected abstract byte[] calendar();

    protected abstract byte[] era(long var1);

    public final byte[] formatDate(ADate date, byte[] language, byte[] picture, byte[] calendar, byte[] place, StaticContext sc, InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (language.length != 0 && MAP.get(language) == null) {
            tb.add("[Language: en]");
        }
        if (calendar != null) {
            QNm qnm;
            try {
                qnm = QNm.resolve(Token.trim(calendar), sc);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.CALWHICH_X.get(ii, new Object[]{calendar});
            }
            if (qnm.uri().length == 0) {
                int c = -1;
                byte[] ln = qnm.local();
                int cl = CALENDARS.length;
                while (++c < cl && !Token.eq(CALENDARS[c], ln)) {
                }
                if (c == cl) {
                    throw QueryError.CALWHICH_X.get(ii, new Object[]{calendar});
                }
                if (c > 1) {
                    tb.add("[Calendar: AD]");
                }
            }
        }
        if (place.length != 0) {
            tb.add("[Place: ]");
        }
        DateParser dp = new DateParser(ii, picture);
        while (dp.more()) {
            int ch = dp.literal();
            if (ch == -1) {
                byte[] marker = dp.marker();
                if (marker.length == 0) {
                    throw QueryError.PICDATE_X.get(ii, new Object[]{picture});
                }
                int compSpec = Formatter.ch(marker, 0);
                byte[] pres = Token.ONE;
                boolean max = false;
                BigDecimal frac = null;
                long num = 0L;
                Type type = date.type;
                boolean dat = type == AtomType.DATE;
                boolean tim = type == AtomType.TIME;
                boolean err = false;
                switch (compSpec) {
                    case 89: {
                        num = Math.abs(date.yea());
                        max = true;
                        err = tim;
                        break;
                    }
                    case 77: {
                        num = date.mon();
                        err = tim;
                        break;
                    }
                    case 68: {
                        num = date.day();
                        err = tim;
                        break;
                    }
                    case 100: {
                        long y = date.yea();
                        int m = (int)date.mon() - 1;
                        while (--m >= 0) {
                            num += (long)ADate.dpm(y, m);
                        }
                        num += date.day();
                        err = tim;
                        break;
                    }
                    case 70: {
                        num = date.toJava().toGregorianCalendar().get(7) - 1;
                        if (num == 0L) {
                            num = 7L;
                        }
                        pres = N;
                        err = tim;
                        break;
                    }
                    case 87: {
                        num = date.toJava().toGregorianCalendar().get(3);
                        err = tim;
                        break;
                    }
                    case 119: {
                        num = date.toJava().toGregorianCalendar().get(4);
                        if (num == 0L) {
                            num = new Dtm(new Dtm(date), new DTDur(date.day() * 24L, 0L), false, ii).toJava().toGregorianCalendar().get(4);
                        }
                        err = tim;
                        break;
                    }
                    case 72: {
                        num = date.hour();
                        err = dat;
                        break;
                    }
                    case 104: {
                        num = date.hour() % 12L;
                        if (num == 0L) {
                            num = 12L;
                        }
                        err = dat;
                        break;
                    }
                    case 80: {
                        num = date.hour() / 12L;
                        pres = N;
                        err = dat;
                        break;
                    }
                    case 109: {
                        num = date.minute();
                        pres = Token.token("01");
                        err = dat;
                        break;
                    }
                    case 115: {
                        num = date.sec().intValue();
                        pres = Token.token("01");
                        err = dat;
                        break;
                    }
                    case 102: {
                        frac = date.sec().remainder(BigDecimal.ONE);
                        err = dat;
                        break;
                    }
                    case 90: 
                    case 122: {
                        num = date.tz();
                        pres = Token.token("01:01");
                        break;
                    }
                    case 67: {
                        pres = N;
                        break;
                    }
                    case 69: {
                        num = date.yea();
                        pres = N;
                        err = tim;
                        break;
                    }
                    default: {
                        throw QueryError.INVCOMPSPEC_X.get(ii, new Object[]{marker});
                    }
                }
                if (err) {
                    throw QueryError.PICINVCOMP_X_X_X.get(ii, marker, type, date);
                }
                if (pres == null) continue;
                DateFormat fp = new DateFormat(Token.substring(marker, 1), pres, ii);
                if (max && fp.max == Integer.MAX_VALUE) {
                    int mx = 0;
                    int fl = fp.primary.length;
                    for (int s = 0; s < fl; s += Token.cl(fp.primary, s)) {
                        ++mx;
                    }
                    if (mx > 1) {
                        fp.max = mx;
                    }
                }
                if (compSpec == 122 || compSpec == 90) {
                    tb.add(this.formatZone((int)num, fp, marker));
                    continue;
                }
                if (fp.first == 110) {
                    byte[] in = null;
                    switch (compSpec) {
                        case 77: {
                            in = this.month((int)num - 1, fp.min, fp.max);
                            break;
                        }
                        case 70: {
                            in = this.day((int)num - 1, fp.min, fp.max);
                            break;
                        }
                        case 80: {
                            in = this.ampm(num == 0L);
                            break;
                        }
                        case 67: {
                            in = this.calendar();
                            break;
                        }
                        case 69: {
                            in = this.era((int)num);
                        }
                    }
                    if (in != null) {
                        if (fp.cs == FormatUtil.Case.LOWER) {
                            in = Token.lc(in);
                        }
                        if (fp.cs == FormatUtil.Case.UPPER) {
                            in = Token.uc(in);
                        }
                        tb.add(in);
                        continue;
                    }
                    fp.first = 48;
                    fp.primary = Token.ONE;
                    tb.add(this.formatInt(num, fp));
                    continue;
                }
                if (frac != null) {
                    String s = frac.toString().replace("0.", "").replaceAll("0+$", "");
                    if (frac.compareTo(BigDecimal.ZERO) != 0) {
                        int sl = s.length();
                        if (fp.min > sl) {
                            s = Formatter.frac(frac, fp.min);
                        } else if (fp.max < sl) {
                            s = Formatter.frac(frac, fp.max);
                        } else {
                            int fl = Token.length(fp.primary);
                            if (fl != 1 && fl != sl) {
                                s = Formatter.frac(frac, fl);
                            }
                        }
                    }
                    tb.add(Formatter.number(Token.token(s), fp, fp.first));
                    continue;
                }
                tb.add(this.formatInt(num, fp));
                continue;
            }
            tb.add(ch);
        }
        return tb.finish();
    }

    private static String frac(BigDecimal num, int len) {
        String s = num.setScale(len, RoundingMode.DOWN).toString();
        int d = s.indexOf(46);
        return d == -1 ? s : s.substring(d + 1);
    }

    public final byte[] formatInt(long num, FormatParser fp) {
        boolean sign;
        long n = num;
        boolean bl = sign = n < 0L;
        if (sign) {
            n = -n;
        }
        TokenBuilder tb = new TokenBuilder();
        int ch = fp.first;
        if (ch == 119) {
            tb.add(this.word(n, fp.ordinal));
        } else if (ch == KANJI[1]) {
            Formatter.japanese(tb, n);
        } else if (ch == 105) {
            Formatter.roman(tb, n, fp.min);
        } else if (ch == 9312 || ch == 9332 || ch == 9352) {
            if (num < 1L || num > 20L) {
                tb.addLong(num);
            } else {
                tb.add((int)((long)ch + num - 1L));
            }
        } else {
            String seq = Formatter.sequence(ch);
            if (seq != null) {
                Formatter.alpha(tb, num, seq);
            } else {
                tb.add(this.number(n, fp, ch));
            }
        }
        byte[] in = tb.finish();
        if (fp.cs == FormatUtil.Case.LOWER) {
            in = Token.lc(in);
        }
        if (fp.cs == FormatUtil.Case.UPPER) {
            in = Token.uc(in);
        }
        return sign ? Token.concat({45}, in) : in;
    }

    private byte[] formatZone(int num, FormatParser fp, byte[] marker) throws QueryException {
        boolean mil;
        boolean uc = Formatter.ch(marker, 0) == 90;
        boolean bl = mil = uc && Formatter.ch(marker, 1) == 90;
        if (num == Short.MAX_VALUE) {
            byte[] byArray;
            if (mil) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 74;
            } else {
                byArray = Token.EMPTY;
            }
            return byArray;
        }
        TokenBuilder tb = new TokenBuilder();
        if (!mil || !Formatter.addMilZone(num, tb)) {
            boolean minus;
            if (!uc) {
                tb.add("GMT");
            }
            boolean bl2 = minus = num < 0;
            if (fp.trad && num == 0) {
                tb.add(90);
            } else {
                tb.add(minus ? 45 : 43);
                TokenParser tp = new TokenParser(fp.primary);
                int c1 = tp.next();
                int c2 = tp.next();
                int c3 = tp.next();
                int c4 = tp.next();
                int z1 = Formatter.zeroes(c1);
                int z2 = Formatter.zeroes(c2);
                int z3 = Formatter.zeroes(c3);
                int z4 = Formatter.zeroes(c4);
                if (z1 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add("00"))).add(58);
                    tb.add(this.addZone(num, 1, new TokenBuilder().add("00")));
                } else if (z2 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1)));
                    if (c2 == -1) {
                        if (num % 60 != 0) {
                            tb.add(58).add(this.addZone(num, 1, new TokenBuilder().add("00")));
                        }
                    } else {
                        TokenBuilder t = new TokenBuilder().add(z3 == -1 ? 48 : z3);
                        if (z3 != -1 && z4 != -1) {
                            t.add(z4);
                        }
                        tb.add(c2).add(this.addZone(num, 1, t));
                    }
                } else if (z3 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1).add(c2)));
                    if (c3 == -1) {
                        if (num % 60 != 0) {
                            tb.add(58).add(this.addZone(num, 1, new TokenBuilder().add("00")));
                        }
                    } else {
                        int c5 = tp.next();
                        int z5 = Formatter.zeroes(c5);
                        TokenBuilder t = new TokenBuilder().add(z4 == -1 ? 48 : z4);
                        if (z4 != -1 && z5 != -1) {
                            t.add(z5);
                        }
                        tb.add(c3).add(this.addZone(num % 60, 1, t));
                    }
                } else if (z4 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1)));
                    tb.add(this.addZone(num, 1, new TokenBuilder().add(c2).add(c3)));
                } else {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1).add(c2)));
                    tb.add(this.addZone(num, 1, new TokenBuilder().add(c3).add(c4)));
                }
            }
        }
        return tb.finish();
    }

    private byte[] addZone(int num, int c, TokenBuilder format) throws QueryException {
        int n;
        int n2 = n = c == 0 ? num / 60 : num % 60;
        if (num < 0) {
            n = -n;
        }
        return this.number(n, new IntFormat(format.toArray(), null), format.cp(0));
    }

    private static boolean addMilZone(int num, TokenBuilder tb) {
        int n = num / 60;
        if (num % 60 != 0 || n < -12 || n > 12) {
            return false;
        }
        tb.add(MIL[n + 12]);
        return true;
    }

    private static void alpha(TokenBuilder tb, long n, String a) {
        int al = a.length();
        if (n > (long)al) {
            Formatter.alpha(tb, (n - 1L) / (long)al, a);
        }
        if (n > 0L) {
            tb.add(a.charAt((int)((n - 1L) % (long)al)));
        } else {
            tb.add(Token.ZERO);
        }
    }

    private static void roman(TokenBuilder tb, long n, int min) {
        int sz = tb.size();
        if (n > 0L && n < 4000L) {
            int v = (int)n;
            tb.add(ROMANM[v / 1000]);
            tb.add(ROMANC[v / 100 % 10]);
            tb.add(ROMANX[v / 10 % 10]);
            tb.add(ROMANI[v % 10]);
        } else {
            tb.addLong(n);
        }
        while (tb.size() - sz < min) {
            tb.add(32);
        }
    }

    private static void japanese(TokenBuilder tb, long n) {
        if (n == 0L) {
            tb.add(KANJI[0]);
        } else {
            Formatter.jp(tb, n, false);
        }
    }

    private static void jp(TokenBuilder tb, long n, boolean i) {
        if (n != 0L) {
            if (n <= 9L) {
                if (n != 1L || !i) {
                    tb.add(KANJI[(int)n]);
                }
            } else if (n == 10L) {
                tb.add(KANJI[10]);
            } else if (n <= 99L) {
                Formatter.jp(tb, n, 10L, 10);
            } else if (n <= 999L) {
                Formatter.jp(tb, n, 100L, 11);
            } else if (n <= 9999L) {
                Formatter.jp(tb, n, 1000L, 12);
            } else if (n <= 99999999L) {
                Formatter.jp(tb, n, 10000L, 13);
            } else if (n <= 999999999999L) {
                Formatter.jp(tb, n, 100000000L, 14);
            } else if (n <= 9999999999999999L) {
                Formatter.jp(tb, n, 1000000000000L, 15);
            } else {
                tb.addLong(n);
            }
        }
    }

    private static void jp(TokenBuilder tb, long n, long f, int o) {
        Formatter.jp(tb, n / f, true);
        tb.add(KANJI[o]);
        Formatter.jp(tb, n % f, false);
    }

    private byte[] number(long num, FormatParser fp, int first) {
        byte[] n = Formatter.number(Token.token(num, fp.radix), fp, first);
        return Token.concat(n, this.ordinal(num, fp.ordinal));
    }

    private static byte[] number(byte[] num, FormatParser fp, int first) {
        int modStart;
        int zero = Formatter.zeroes(first, fp.radix);
        int[] mod = new TokenParser(fp.primary).toArray();
        int modSize = mod.length;
        for (modStart = 0; modStart < modSize && mod[modStart] == 35; ++modStart) {
        }
        int sepPos = -1;
        int sepChar = -1;
        int digitPos = 0;
        boolean regSep = false;
        for (int mp = modSize - 1; mp >= modStart; --mp) {
            int ch = mod[mp];
            if (Formatter.digit(ch, zero, fp.radix)) {
                digitPos = mp;
                continue;
            }
            if (ch == 35) continue;
            if (sepPos == -1) {
                sepPos = modSize - mp;
                sepChar = ch;
                regSep = true;
                continue;
            }
            if (!regSep) continue;
            regSep = (modSize - mp) % sepPos == 0 && ch == sepChar;
        }
        if (!regSep) {
            sepPos = Integer.MAX_VALUE;
        }
        IntList reverse = new IntList();
        int inPos = num.length - 1;
        int modPos = modSize - 1;
        int min = fp.min;
        int max = fp.max;
        while ((--min >= 0 || inPos >= 0 || modPos >= modStart) && --max >= 0) {
            int n;
            int ch;
            boolean sep;
            boolean bl = sep = reverse.size() % sepPos == sepPos - 1;
            if (modPos >= modStart) {
                ch = mod[modPos--];
                if (inPos >= 0) {
                    if (ch == 35 && sep) {
                        reverse.add(sepChar);
                    }
                    if (ch == 35 || Formatter.digit(ch, zero, fp.radix)) {
                        n = num[inPos--];
                        ch = fp.radix == 10 ? zero + n - 48 : n;
                    }
                } else {
                    if (ch == 35) break;
                    if (Formatter.digit(ch, zero, fp.radix)) {
                        ch = zero;
                    }
                    if (regSep && modPos + 1 < digitPos) {
                        break;
                    }
                }
            } else if (inPos >= 0) {
                if (sep) {
                    reverse.add(sepChar);
                }
                n = num[inPos--];
                ch = fp.radix == 10 ? zero + n - 48 : n;
            } else {
                ch = zero;
            }
            reverse.add(ch);
        }
        while (min-- >= 0) {
            reverse.add(zero);
        }
        TokenBuilder result = new TokenBuilder();
        for (int rs = reverse.size() - 1; rs >= 0; --rs) {
            result.add(reverse.get(rs));
        }
        return result.finish();
    }

    static boolean digit(int ch, int zero, int radix) {
        if (radix == 10) {
            return ch >= zero && ch <= zero + 9;
        }
        int num = ch <= 57 ? ch : (ch & 0xDF) - 55;
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 && num < radix;
    }

    static byte[] format(byte[] token, int min, int max) {
        if (min == 0 && max == Integer.MAX_VALUE) {
            return token;
        }
        int mx = Math.max(3, max);
        TokenBuilder tb = new TokenBuilder(mx);
        TokenParser tp = new TokenParser(token);
        int p = -1;
        while (++p < mx && tp.more()) {
            tb.add(tp.next());
        }
        while (p++ < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    static {
        MAP.put(EN, new FormatterEN());
        MAP.put(Token.token("de"), new FormatterDE());
        MAP.put(Token.token("fr"), new FormatterFR());
    }
}

