/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import org.basex.query.util.fingertree.InnerNode;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.util.Array;
import org.basex.util.Util;

final class PartialInnerNode<N, E>
implements NodeLike<Node<N, E>, E> {
    final NodeLike<N, E> sub;

    PartialInnerNode(NodeLike<N, E> sub) {
        this.sub = sub;
    }

    @Override
    public int append(NodeLike<Node<N, E>, E>[] out, int pos) {
        Node b;
        Node a;
        if (pos == 0) {
            out[0] = this;
            return 1;
        }
        NodeLike<Node<N, E>, E>[] buffer = out;
        NodeLike<Node<Node<N, E>, E>, E> left = out[pos - 1];
        if (left instanceof PartialInnerNode) {
            buffer[pos - 1] = ((PartialInnerNode)left).sub;
            if (this.sub.append(buffer, pos) == pos) {
                out[pos - 1] = new PartialInnerNode<Node<N, E>, E>(buffer[pos - 1]);
            } else {
                Node[] ch = new Node[]{(Node)buffer[pos - 1], (Node)buffer[pos]};
                out[pos - 1] = new InnerNode(ch);
                out[pos] = null;
            }
            return pos;
        }
        Node<N, E>[] children = ((InnerNode)left).children;
        int n = children.length;
        if (this.sub instanceof Node) {
            a = children[n - 1];
            b = (Node)this.sub;
        } else {
            buffer[pos - 1] = children[n - 1];
            if (this.sub.append(buffer, pos) == pos) {
                Node[] ch = (Node[])children.clone();
                ch[n - 1] = (Node)buffer[pos - 1];
                out[pos - 1] = new InnerNode(ch);
                return pos;
            }
            a = (Node)buffer[pos - 1];
            b = (Node)buffer[pos];
        }
        if (n < 4) {
            Node[] ch = new Node[n + 1];
            Array.copy(children, n - 1, ch);
            ch[n - 1] = a;
            ch[n] = b;
            out[pos - 1] = new InnerNode(ch);
            out[pos] = null;
            return pos;
        }
        int ll = (n + 1) / 2;
        int rl = n + 1 - ll;
        Node[] ls = new Node[ll];
        Node[] rs = new Node[rl];
        Array.copy(children, ll, ls);
        Array.copyToStart(children, ll, rl - 2, rs);
        rs[rl - 2] = a;
        rs[rl - 1] = b;
        out[pos - 1] = new InnerNode(ls);
        out[pos] = new InnerNode(rs);
        return pos + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    void toString(StringBuilder sb, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            sb.append(' ').append(' ');
        }
        sb.append(Util.className(this)).append('[').append('\n');
        if (this.sub instanceof InnerNode) {
            ((InnerNode)this.sub).toString(sb, indent + 1);
        } else if (this.sub instanceof PartialInnerNode) {
            ((PartialInnerNode)this.sub).toString(sb, indent + 1);
        } else {
            for (String line : this.sub.toString().split("\r\n?|\n")) {
                for (int i2 = 0; i2 <= indent; ++i2) {
                    sb.append(' ').append(' ');
                }
                sb.append(line).append('\n');
            }
        }
        for (i = 0; i < indent; ++i) {
            sb.append(' ').append(' ');
        }
        sb.append(']');
    }
}

