/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import org.basex.query.QueryContext;
import org.basex.query.util.fingertree.EmptyTree;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.InnerNode;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.util.fingertree.PartialInnerNode;
import org.basex.query.util.fingertree.SingletonTree;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.util.Array;

final class DeepTree<N, E>
extends FingerTree<N, E> {
    private static final int NODE_SIZE = 4;
    final Node<N, E>[] left;
    final long leftSize;
    final FingerTree<Node<N, E>, E> middle;
    final Node<N, E>[] right;
    private final long size;

    DeepTree(Node<N, E>[] left, long leftSize, FingerTree<Node<N, E>, E> middle, Node<N, E>[] right, long size) {
        this.left = left;
        this.leftSize = leftSize;
        this.middle = middle;
        this.right = right;
        this.size = size;
        assert (left.length > 0 && right.length > 0 && size == leftSize + middle.size() + DeepTree.size((Node[])right));
    }

    static <N, E> DeepTree<N, E> get(Node<N, E>[] left, FingerTree<Node<N, E>, E> middle, Node<N, E>[] right, long size) {
        return new DeepTree<N, E>(left, DeepTree.size((Node[])left), middle, right, size);
    }

    static <N, E> DeepTree<N, E> get(Node<N, E>[] left, long leftSize, Node<N, E>[] right, long size) {
        return new DeepTree<N, E>(left, leftSize, EmptyTree.getInstance(), right, size);
    }

    static <N, E> DeepTree<N, E> get(Node<N, E>[] left, Node<N, E>[] right, long size) {
        return new DeepTree<N, E>(left, DeepTree.size((Node[])left), EmptyTree.getInstance(), right, size);
    }

    static <N, E> DeepTree<N, E> get(Node<N, E>[] left, FingerTree<Node<N, E>, E> middle, Node<N, E>[] right) {
        long l = DeepTree.size((Node[])left);
        long m = middle.size();
        long r = DeepTree.size((Node[])right);
        return new DeepTree<N, E>(left, l, middle, right, l + m + r);
    }

    static <N, E> DeepTree<N, E> get(Node<N, E>[] left, Node<N, E>[] right) {
        long l = DeepTree.size((Node[])left);
        long r = DeepTree.size((Node[])right);
        return new DeepTree<N, E>(left, l, EmptyTree.getInstance(), right, l + r);
    }

    @Override
    public DeepTree<N, E> cons(Node<N, E> fst) {
        long sz = fst.size();
        if (this.left.length < 5) {
            Node<N, E>[] newLeft = DeepTree.slice(this.left, -1, this.left.length);
            newLeft[0] = fst;
            return new DeepTree<N, E>(newLeft, this.leftSize + sz, this.middle, this.right, this.size + sz);
        }
        int ll = this.left.length;
        int m = ll - 4;
        Node<N, E>[] newLeft = DeepTree.slice(this.left, -1, m);
        Node<N, E>[] sub = DeepTree.slice(this.left, m, ll);
        newLeft[0] = fst;
        FingerTree<Node<N, E>, E> mid = this.middle.cons(new InnerNode<N, E>(sub));
        return DeepTree.get(newLeft, mid, this.right, this.size + sz);
    }

    @Override
    public DeepTree<N, E> snoc(Node<N, E> lst) {
        if (this.right.length < 5) {
            Node<N, E>[] newRight = DeepTree.slice(this.right, 0, this.right.length + 1);
            newRight[this.right.length] = lst;
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle, newRight, this.size + lst.size());
        }
        int rl = this.right.length;
        int m = 4;
        Node<N, E>[] sub = DeepTree.slice(this.right, 0, 4);
        Node<N, E>[] newRight = DeepTree.slice(this.right, 4, rl + 1);
        newRight[rl - 4] = lst;
        FingerTree<Node<N, E>, E> mid = this.middle.snoc(new InnerNode<N, E>(sub));
        return new DeepTree<N, E>(this.left, this.leftSize, mid, newRight, this.size + lst.size());
    }

    @Override
    public Node<N, E> head() {
        return this.left[0];
    }

    @Override
    public Node<N, E> last() {
        return this.right[this.right.length - 1];
    }

    @Override
    public FingerTree<N, E> init() {
        long newSize = this.size - this.right[this.right.length - 1].size();
        if (this.right.length > 1) {
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle, DeepTree.slice(this.right, 0, this.right.length - 1), newSize);
        }
        if (this.middle.isEmpty()) {
            if (this.left.length == 1) {
                return new SingletonTree<N, E>(this.left[0]);
            }
            int mid = this.left.length / 2;
            return DeepTree.get(DeepTree.slice(this.left, 0, mid), DeepTree.slice(this.left, mid, this.left.length), newSize);
        }
        InnerNode last = (InnerNode)this.middle.last();
        return new DeepTree<N, E>(this.left, this.leftSize, this.middle.init(), last.children, newSize);
    }

    @Override
    public FingerTree<N, E> tail() {
        long fstSize = this.left[0].size();
        long newSize = this.size - fstSize;
        if (this.left.length > 1) {
            Node<N, E>[] newLeft = DeepTree.slice(this.left, 1, this.left.length);
            return new DeepTree<N, E>(newLeft, this.leftSize - fstSize, this.middle, this.right, newSize);
        }
        if (this.middle.isEmpty()) {
            if (this.right.length == 1) {
                return new SingletonTree<N, E>(this.right[0]);
            }
            int mid = this.right.length / 2;
            return DeepTree.get(DeepTree.slice(this.right, 0, mid), DeepTree.slice(this.right, mid, this.right.length), newSize);
        }
        InnerNode head = (InnerNode)this.middle.head();
        return new DeepTree(head.children, head.size(), this.middle.tail(), this.right, newSize);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public DeepTree<N, E> concat(Node<N, E>[] nodes, long sz, FingerTree<N, E> other) {
        DeepTree lft = (DeepTree)this.addAll(nodes, sz, false);
        if (!(other instanceof DeepTree)) {
            return other.isEmpty() ? lft : lft.snoc((Node)other.head());
        }
        DeepTree rght = (DeepTree)other;
        Node<N, E>[] as = lft.right;
        Node<N, E>[] bs = rght.left;
        int l = as.length;
        int n = l + bs.length;
        int k = (n + 4 - 1) / 4;
        Node[] out = new Node[k];
        int p = 0;
        for (int i = 0; i < k; ++i) {
            int rem = k - i;
            int curr = (n - p + rem - 1) / rem;
            Node[] ch = new Node[curr];
            int inL = l - p;
            if (curr <= inL) {
                Array.copyToStart(as, p, curr, ch);
            } else if (inL > 0) {
                Array.copyToStart(as, p, inL, ch);
                Array.copyFromStart(bs, curr - inL, ch, inL);
            } else {
                Array.copyToStart(bs, -inL, curr, ch);
            }
            out[i] = new InnerNode(ch);
            p += curr;
        }
        long inMid = lft.rightSize() + rght.leftSize;
        FingerTree<Node<N, E>, E> newMid = lft.middle.concat(out, inMid, rght.middle);
        long newSize = lft.leftSize + newMid.size() + rght.rightSize();
        return new DeepTree<N, E>(lft.left, lft.leftSize, newMid, rght.right, newSize);
    }

    @Override
    public FingerTree<N, E> reverse(QueryContext qc) {
        int i;
        qc.checkStop();
        int l = this.left.length;
        int r = this.right.length;
        Node[] newLeft = new Node[r];
        Node[] newRight = new Node[l];
        for (i = 0; i < r; ++i) {
            newLeft[i] = this.right[r - 1 - i].reverse();
        }
        for (i = 0; i < l; ++i) {
            newRight[i] = this.left[l - 1 - i].reverse();
        }
        return new DeepTree<N, E>(newLeft, this.rightSize(), this.middle.reverse(qc), newRight, this.size);
    }

    @Override
    public FingerTree<N, E> set(long pos, E val) {
        long sub;
        long off = pos;
        if (off < this.leftSize) {
            long sub2;
            Node[] newLeft = (Node[])this.left.clone();
            int i = 0;
            while (off >= (sub2 = newLeft[i].size())) {
                off -= sub2;
                ++i;
            }
            newLeft[i] = newLeft[i].set(off, val);
            return new DeepTree<N, E>(newLeft, this.leftSize, this.middle, this.right, this.size);
        }
        long mid = this.middle.size();
        if ((off -= this.leftSize) < mid) {
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle.set(off, val), this.right, this.size);
        }
        off -= mid;
        Node[] newRight = (Node[])this.right.clone();
        int i = 0;
        while (off >= (sub = newRight[i].size())) {
            off -= sub;
            ++i;
        }
        newRight[i] = newRight[i].set(off, val);
        return new DeepTree<N, E>(this.left, this.leftSize, this.middle, newRight, this.size);
    }

    @Override
    public FingerTree<N, E> insert(long pos, E val, QueryContext qc) {
        long sub;
        qc.checkStop();
        if (pos <= this.leftSize) {
            long sub2;
            int i = 0;
            long p = pos;
            while (p > (sub2 = this.left[i].size())) {
                p -= sub2;
                ++i;
            }
            int ll = this.left.length;
            Node<N, E> l = i > 0 ? this.left[i - 1] : null;
            Node<N, E> r = i + 1 < ll ? this.left[i + 1] : null;
            Node[] siblings = new Node[]{l, null, r, null};
            if (!this.left[i].insert(siblings, p, val)) {
                Node[] newLeft = (Node[])this.left.clone();
                if (i > 0) {
                    newLeft[i - 1] = siblings[0];
                }
                newLeft[i] = siblings[1];
                if (i + 1 < ll) {
                    newLeft[i + 1] = siblings[2];
                }
                return new DeepTree<N, E>(newLeft, this.leftSize + 1L, this.middle, this.right, this.size + 1L);
            }
            Node[] temp = new Node[ll + 1];
            if (i > 0) {
                Array.copy(this.left, i - 1, temp);
                temp[i - 1] = siblings[0];
            }
            temp[i] = siblings[1];
            temp[i + 1] = siblings[2];
            if (i + 1 < ll) {
                temp[i + 2] = siblings[3];
                Array.copy(this.left, i + 2, ll - i - 2, temp, i + 3);
            }
            if (ll < 5) {
                return new DeepTree<N, E>(temp, this.leftSize + 1L, this.middle, this.right, this.size + 1L);
            }
            int m = temp.length - 4;
            Node<N, E>[] newLeft = DeepTree.slice(temp, 0, m);
            Node<N, E>[] ch = DeepTree.slice(temp, m, temp.length);
            return DeepTree.get(newLeft, this.middle.cons(new InnerNode<N, E>(ch)), this.right, this.size + 1L);
        }
        long p = pos - this.leftSize;
        long midSize = this.middle.size();
        if (p < midSize) {
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle.insert(p, val, qc), this.right, this.size + 1L);
        }
        p -= midSize;
        int i = 0;
        while (p > (sub = this.right[i].size())) {
            p -= sub;
            ++i;
        }
        int rl = this.right.length;
        Node<N, E> l = i > 0 ? this.right[i - 1] : null;
        Node<N, E> r = i + 1 < rl ? this.right[i + 1] : null;
        Node[] siblings = new Node[]{l, null, r, null};
        if (!this.right[i].insert(siblings, p, val)) {
            Node[] newRight = (Node[])this.right.clone();
            if (i > 0) {
                newRight[i - 1] = siblings[0];
            }
            newRight[i] = siblings[1];
            if (i + 1 < rl) {
                newRight[i + 1] = siblings[2];
            }
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle, newRight, this.size + 1L);
        }
        Node[] temp = new Node[rl + 1];
        if (i > 0) {
            Array.copy(this.right, i - 1, temp);
            temp[i - 1] = siblings[0];
        }
        temp[i] = siblings[1];
        temp[i + 1] = siblings[2];
        if (i + 1 < rl) {
            temp[i + 2] = siblings[3];
            Array.copy(this.right, i + 2, rl - i - 2, temp, i + 3);
        }
        if (this.right.length < 5) {
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle, temp, this.size + 1L);
        }
        int m = 4;
        Node<N, E>[] ch = DeepTree.slice(temp, 0, 4);
        Node<N, E>[] newRight = DeepTree.slice(temp, 4, temp.length);
        return new DeepTree<N, E>(this.left, this.leftSize, this.middle.snoc(new InnerNode<N, E>(ch)), newRight, this.size + 1L);
    }

    @Override
    public TreeSlice<N, E> remove(long pos, QueryContext qc) {
        qc.checkStop();
        if (pos < this.leftSize) {
            return new TreeSlice<N, E>(this.removeLeft(pos));
        }
        long rightStart = this.leftSize + this.middle.size();
        if (pos >= rightStart) {
            return new TreeSlice<N, E>(this.removeRight(pos - rightStart));
        }
        TreeSlice<Node<N, E>, E> slice = this.middle.remove(pos - this.leftSize, qc);
        if (slice.isTree()) {
            FingerTree<Node<N, E>, E> newMiddle = slice.getTree();
            return slice.setTree(new DeepTree<N, E>(this.left, this.leftSize, newMiddle, this.right, this.size - 1L));
        }
        Node node = (Node)((PartialInnerNode)slice.getPartial()).sub;
        if (this.left.length < this.right.length) {
            Node<N, E>[] newLeft = DeepTree.slice(this.left, 0, this.left.length + 1);
            newLeft[this.left.length] = node;
            return slice.setTree(DeepTree.get(newLeft, this.leftSize + node.size(), this.right, this.size - 1L));
        }
        if (this.right.length < 5) {
            Node<N, E>[] newRight = DeepTree.slice(this.right, -1, this.right.length);
            newRight[0] = node;
            return slice.setTree(DeepTree.get(this.left, this.leftSize, newRight, this.size - 1L));
        }
        int n = 11;
        int ll = 3;
        Node<N, E>[] newLeft = DeepTree.slice(this.left, 0, 3);
        Node[] ch = new Node[4];
        int inL = this.left.length - 3;
        int inR = 4 - inL - 1;
        Array.copyToStart(this.left, 3, inL, ch);
        ch[inL] = node;
        Array.copyFromStart(this.right, inR, ch, inL + 1);
        Node<N, E>[] newRight = DeepTree.slice(this.right, inR, 5);
        InnerNode newMid = new InnerNode(ch);
        return slice.setTree(DeepTree.get(newLeft, new SingletonTree(newMid), newRight, this.size - 1L));
    }

    private FingerTree<N, E> removeLeft(long pos) {
        if (this.left.length > 1) {
            return new DeepTree<N, E>(DeepTree.remove(this.left, pos), this.leftSize - 1L, this.middle, this.right, this.size - 1L);
        }
        Node node = this.left[0];
        if (!this.middle.isEmpty()) {
            InnerNode head = (InnerNode)this.middle.head();
            Object first = head.getSub(0);
            NodeLike<N, E>[] rem = node.remove(null, first, pos);
            Node newNode = (Node)rem[1];
            Node newFirst = (Node)rem[2];
            if (newNode == null) {
                Node[] newLeft = (Node[])head.children.clone();
                newLeft[0] = newFirst;
                return DeepTree.get(newLeft, this.middle.tail(), this.right, this.size - 1L);
            }
            Node[] newLeft = new Node[]{newNode};
            if (newFirst != first) {
                FingerTree<Node<N, E>, E> newMid = this.middle.replaceHead(head.replaceFirst(newFirst));
                return new DeepTree<N, E>(newLeft, newNode.size(), newMid, this.right, this.size - 1L);
            }
            return new DeepTree<N, E>(newLeft, newNode.size(), this.middle, this.right, this.size - 1L);
        }
        NodeLike<N, E>[] rem = node.remove(null, this.right[0], pos);
        Node newNode = (Node)rem[1];
        Node newFirstRight = (Node)rem[2];
        if (newNode == null) {
            if (this.right.length == 1) {
                return new SingletonTree(newFirstRight);
            }
            int mid = this.right.length / 2;
            Node<N, E>[] newLeft = DeepTree.slice(this.right, 0, mid);
            newLeft[0] = newFirstRight;
            return DeepTree.get(newLeft, this.middle, DeepTree.slice(this.right, mid, this.right.length), this.size - 1L);
        }
        Node[] newLeft = new Node[]{newNode};
        if (newFirstRight == this.right[0]) {
            return new DeepTree<N, E>(newLeft, newLeft[0].size(), this.middle, this.right, this.size - 1L);
        }
        Node[] newRight = (Node[])this.right.clone();
        newRight[0] = newFirstRight;
        return new DeepTree<N, E>(newLeft, newNode.size(), this.middle, newRight, this.size - 1L);
    }

    private FingerTree<N, E> removeRight(long pos) {
        if (this.right.length > 1) {
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle, DeepTree.remove(this.right, pos), this.size - 1L);
        }
        Node<N, E> node = this.right[0];
        if (!this.middle.isEmpty()) {
            InnerNode last = (InnerNode)this.middle.last();
            Object lastSub = last.getSub(last.arity() - 1);
            NodeLike<N, E>[] rem = node.remove((Node<N, E>)lastSub, null, pos);
            Node newLastSub = (Node)rem[0];
            Node newNode = (Node)rem[1];
            if (newNode == null) {
                Node[] newRight = (Node[])last.children.clone();
                newRight[newRight.length - 1] = newLastSub;
                return new DeepTree<N, E>(this.left, this.leftSize, this.middle.init(), newRight, this.size - 1L);
            }
            Node[] newRight = new Node[]{newNode};
            InnerNode newLast = last.replaceLast(newLastSub);
            return new DeepTree<N, E>(this.left, this.leftSize, this.middle.replaceLast(newLast), newRight, this.size - 1L);
        }
        Node<N, E> lastLeft = this.left[this.left.length - 1];
        NodeLike<N, E>[] rem = node.remove(lastLeft, null, pos);
        Node newLastLeft = (Node)rem[0];
        Node newNode = (Node)rem[1];
        if (newNode == null) {
            if (this.left.length == 1) {
                return new SingletonTree(newLastLeft);
            }
            Node[] newRight = new Node[]{newLastLeft};
            return DeepTree.get(DeepTree.slice(this.left, 0, this.left.length - 1), newRight, this.size - 1L);
        }
        Node[] newRight = new Node[]{newNode};
        if (newLastLeft == lastLeft) {
            return DeepTree.get(this.left, this.leftSize, newRight, this.size - 1L);
        }
        Node[] newLeft = (Node[])this.left.clone();
        newLeft[newLeft.length - 1] = newLastLeft;
        return DeepTree.get(newLeft, newRight, this.size - 1L);
    }

    private static <N, E> Node<N, E>[] remove(Node<N, E>[] arr, long pos) {
        Node<N, E> node;
        long nodeSize;
        int i = 0;
        long off = pos;
        while (off >= (nodeSize = (node = arr[i]).size())) {
            off -= nodeSize;
            ++i;
        }
        int n = arr.length;
        NodeLike<N, E>[] res = arr[i].remove(i == 0 ? null : arr[i - 1], i == n - 1 ? null : arr[i + 1], off);
        Node l = (Node)res[0];
        Node m = (Node)res[1];
        Node r = (Node)res[2];
        if (m != null) {
            Node[] out = (Node[])arr.clone();
            if (i > 0) {
                out[i - 1] = l;
            }
            out[i] = m;
            if (i < n - 1) {
                out[i + 1] = r;
            }
            return out;
        }
        Node[] out = new Node[n - 1];
        if (i > 0) {
            Array.copy(arr, i - 1, out);
            out[i - 1] = l;
        }
        if (i < n - 1) {
            out[i] = r;
            Array.copy(arr, i + 2, n - i - 2, out, i + 1);
        }
        return out;
    }

    @Override
    public TreeSlice<N, E> slice(long from, long len) {
        Node<N, E>[] newRight;
        FingerTree mid3;
        FingerTree mid2;
        long rightFrom;
        TreeSlice<Object, E> slice;
        FingerTree mid;
        long inLeft;
        if (from == 0L && len == this.size) {
            return new TreeSlice(this);
        }
        long midSize = this.middle.size();
        long rightOff = this.leftSize + midSize;
        long l = from + len <= this.leftSize ? len : (inLeft = from < this.leftSize ? this.leftSize - from : 0L);
        long inRight = from >= rightOff ? len : (from + len > rightOff ? from + len - rightOff : 0L);
        NodeLike[] buffer = new NodeLike[11];
        int inBuffer = DeepTree.splitDigit(this.left, from, inLeft, buffer, 0);
        if (inLeft == len) {
            if (inBuffer == 1) {
                return new TreeSlice(buffer[0]);
            }
            int mid1 = inBuffer / 2;
            Node<N, E>[] ls = DeepTree.slice(buffer, 0, mid1);
            Node<N, E>[] rs = DeepTree.slice(buffer, mid1, inBuffer);
            return new TreeSlice<N, E>(DeepTree.get(ls, rs, len));
        }
        long inMiddle = len - inLeft - inRight;
        if (inMiddle == 0L) {
            mid = EmptyTree.getInstance();
            slice = new TreeSlice(mid);
        } else {
            long midOff = from <= this.leftSize ? 0L : from - this.leftSize;
            slice = this.middle.slice(midOff, inMiddle);
            if (slice.isTree()) {
                mid = slice.getTree();
            } else {
                NodeLike sub = ((PartialInnerNode)slice.getPartial()).sub;
                inBuffer = sub.append(buffer, inBuffer);
                mid = EmptyTree.getInstance();
            }
        }
        long l2 = rightFrom = from < rightOff ? 0L : from - rightOff;
        if (mid.isEmpty()) {
            inBuffer = DeepTree.splitDigit(this.right, rightFrom, inRight, buffer, inBuffer);
            return slice.setNodes(buffer, inBuffer, len);
        }
        if (inBuffer > 1 || buffer[0] instanceof Node) {
            mid2 = mid;
        } else {
            InnerNode head = (InnerNode)mid.head();
            int k = head.arity();
            inBuffer = head.getSub(0).append(buffer, inBuffer);
            for (int i = 1; i < k; ++i) {
                buffer[inBuffer++] = head.getSub(i);
            }
            mid2 = mid.tail();
        }
        if (mid2.isEmpty()) {
            inBuffer = DeepTree.splitDigit(this.right, rightFrom, inRight, buffer, inBuffer);
            return slice.setNodes(buffer, inBuffer, len);
        }
        Node<N, E>[] newLeft = DeepTree.slice(buffer, 0, inBuffer);
        inBuffer = DeepTree.splitDigit(this.right, rightFrom, inRight, buffer, 0);
        if (inBuffer == 0) {
            mid3 = mid2.init();
            newRight = ((InnerNode)mid2.last()).children;
        } else {
            if (inBuffer > 1 || buffer[0] instanceof Node) {
                mid3 = mid2;
            } else {
                NodeLike partial = buffer[0];
                InnerNode last = (InnerNode)mid2.last();
                int k = last.arity();
                for (int i = 0; i < k; ++i) {
                    buffer[i] = last.getSub(i);
                }
                inBuffer = partial.append(buffer, k);
                mid3 = mid2.init();
            }
            newRight = DeepTree.slice(buffer, 0, inBuffer);
        }
        return slice.setTree(DeepTree.get(newLeft, mid3, newRight, len));
    }

    private static <N, E> int splitDigit(Node<N, E>[] nodes, long from, long len, NodeLike<N, E>[] buffer, int inBuffer) {
        long currSize;
        long firstOff;
        if (len <= 0L) {
            return inBuffer;
        }
        int firstPos = 0;
        Node<N, E> first = nodes[0];
        long firstSize = first.size();
        for (firstOff = from; firstOff >= firstSize; firstOff -= firstSize) {
            first = nodes[++firstPos];
            firstSize = first.size();
        }
        long inFirst = firstSize - firstOff;
        if (inFirst >= len) {
            Node<N, E> part = len == firstSize ? first : first.slice(firstOff, len);
            return part.append(buffer, inBuffer);
        }
        Node<N, E> firstSlice = firstOff == 0L ? first : first.slice(firstOff, inFirst);
        int numMerged = firstSlice.append(buffer, inBuffer);
        int pos = firstPos;
        for (long remaining = len - inFirst; remaining > 0L; remaining -= currSize) {
            Node<N, E> curr;
            Node<N, E> slice = remaining >= (currSize = (curr = nodes[++pos]).size()) ? curr : curr.slice(0L, remaining);
            numMerged = slice.append(buffer, numMerged);
        }
        return numMerged;
    }

    private long rightSize() {
        return this.size - this.leftSize - this.middle.size();
    }

    @Override
    FingerTree<N, E> addAll(Node<N, E>[] nodes, long sz, boolean appendLeft) {
        int k = nodes.length;
        if (k == 0) {
            return this;
        }
        if (k == 1) {
            return appendLeft ? this.cons((Node)nodes[0]) : this.snoc((Node)nodes[0]);
        }
        if (appendLeft) {
            int l = k + this.left.length;
            Node<N, E>[] ls = DeepTree.slice(nodes, 0, l);
            Array.copyFromStart(this.left, this.left.length, ls, k);
            if (l <= 5) {
                return DeepTree.get(ls, this.middle, this.right);
            }
            FingerTree<Node<N, E>, E> newMid = this.middle;
            for (int rem = (l + 4 - 1) / 4; rem > 1; --rem) {
                int curr = (l + rem - 1) / rem;
                newMid = newMid.cons(new InnerNode<N, E>(DeepTree.slice(ls, l - curr, l)));
                l -= curr;
            }
            return DeepTree.get(DeepTree.slice(ls, 0, l), newMid, this.right);
        }
        int r = this.right.length + k;
        Node<N, E>[] rs = DeepTree.slice(this.right, 0, r);
        Array.copyFromStart(nodes, k, rs, this.right.length);
        if (k + this.right.length <= 5) {
            return DeepTree.get(this.left, this.middle, rs);
        }
        int i = 0;
        FingerTree<Node<N, E>, E> newMid = this.middle;
        for (int rem = (r + 4 - 1) / 4; rem > 1; --rem) {
            int curr = (r - i + rem - 1) / rem;
            newMid = newMid.snoc(new InnerNode<N, E>(DeepTree.slice(rs, i, i + curr)));
            i += curr;
        }
        return DeepTree.get(this.left, newMid, DeepTree.slice(rs, i, r));
    }

    @Override
    public FingerTree<N, E> replaceHead(Node<N, E> head) {
        long sizeDiff = head.size() - this.left[0].size();
        Node[] newLeft = (Node[])this.left.clone();
        newLeft[0] = head;
        return new DeepTree<N, E>(newLeft, this.leftSize + sizeDiff, this.middle, this.right, this.size + sizeDiff);
    }

    @Override
    public FingerTree<N, E> replaceLast(Node<N, E> last) {
        int lst = this.right.length - 1;
        Node[] newRight = (Node[])this.right.clone();
        newRight[lst] = last;
        return new DeepTree<N, E>(this.left, this.leftSize, this.middle, newRight, this.size + last.size() - this.right[lst].size());
    }

    @Override
    void toString(StringBuilder sb, int indent) {
        sb.append("  ".repeat(indent)).append("Deep(").append(this.size).append(")[\n");
        sb.append("  ".repeat(indent + 1)).append("Left(").append(this.leftSize).append(")[\n");
        for (Node<N, E> e : this.left) {
            DeepTree.toString(e, sb, indent + 2);
            sb.append('\n');
        }
        sb.append("  ".repeat(indent + 1)).append("]\n");
        this.middle.toString(sb, indent + 1);
        sb.append('\n');
        sb.append("  ".repeat(indent + 1)).append("Right[\n");
        for (Node<N, E> e : this.right) {
            DeepTree.toString(e, sb, indent + 2);
            sb.append('\n');
        }
        sb.append("  ".repeat(indent + 1)).append("]\n").append("  ".repeat(indent)).append(']');
    }

    @Override
    public long checkInvariants() {
        if (this.left.length < 1 || this.left.length > 5) {
            throw new AssertionError((Object)("Wrong left digit length: " + this.left.length));
        }
        long sz = 0L;
        for (Node<N, E> nd : this.left) {
            sz += nd.checkInvariants();
        }
        if (sz != this.leftSize) {
            throw new AssertionError((Object)("Wrong leftSize: " + this.leftSize + " vs. " + sz));
        }
        sz += this.middle.checkInvariants();
        if (this.right.length < 1 || this.right.length > 5) {
            throw new AssertionError((Object)("Wrong right digit length: " + this.right.length));
        }
        for (Node<N, E> nd : this.right) {
            sz += nd.checkInvariants();
        }
        if (sz != this.size) {
            throw new AssertionError((Object)("Wrong size: " + this.size + " vs. " + sz));
        }
        return sz;
    }

    static <N extends Node<?, ?>> long size(N[] arr) {
        long size = 0L;
        for (N o : arr) {
            size += o.size();
        }
        return size;
    }

    static <N, E> Node<N, E>[] slice(NodeLike<N, E>[] arr, int from, int to) {
        Node[] out = new Node[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, arr.length);
        int out0 = Math.max(-from, 0);
        Array.copy(arr, in0, in1 - in0, out, out0);
        return out;
    }
}

