/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class NSContext {
    public final Atts list = new Atts();
    private Atts stack;

    public void add(byte[] prefix, byte[] uri, InputInfo ii) throws QueryException {
        if (Token.eq(prefix, Token.XML, Token.XMLNS)) {
            throw QueryError.BINDXML_X.get(ii, new Object[]{prefix});
        }
        if (Token.eq(uri, QueryText.XML_URI)) {
            throw QueryError.BINDXMLURI_X_X.get(ii, uri, Token.XML);
        }
        if (Token.eq(uri, QueryText.XMLNS_URI)) {
            throw QueryError.BINDXMLURI_X_X.get(ii, uri, Token.XMLNS);
        }
        this.list.add(prefix, uri);
    }

    public void delete(byte[] prefix) {
        for (int s = this.list.size() - 1; s >= 0; --s) {
            if (!Token.eq(prefix, this.list.name(s))) continue;
            this.list.remove(s);
            break;
        }
    }

    public byte[] staticURI(byte[] prefix) {
        for (int s = this.list.size() - 1; s >= 0; --s) {
            if (!Token.eq(this.list.name(s), prefix)) continue;
            return this.list.value(s);
        }
        return null;
    }

    public byte[] uri(byte[] prefix) {
        byte[] u;
        if (this.stack != null) {
            for (int s = this.stack.size() - 1; s >= 0; --s) {
                if (!Token.eq(this.stack.name(s), prefix)) continue;
                return this.stack.value(s);
            }
        }
        return (u = this.staticURI(prefix)) == null ? (prefix.length == 0 ? null : NSGlobal.uri(prefix)) : (u.length == 0 ? null : u);
    }

    public int size() {
        return this.stack().size();
    }

    public void size(int size) {
        this.stack().size(size);
    }

    public void add(byte[] prefix, byte[] uri) {
        this.stack().add(prefix, uri);
    }

    public void inScope(Atts atts) {
        if (this.stack != null) {
            for (int s = this.stack.size() - 1; s >= 0; --s) {
                byte[] nm = this.stack.name(s);
                if (atts.contains(nm)) continue;
                atts.add(nm, this.stack.value(s));
            }
        }
    }

    private Atts stack() {
        if (this.stack == null) {
            this.stack = new Atts();
        }
        return this.stack;
    }
}

