/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.DataFTBuilder;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public final class DataBuilder {
    private final QueryContext qc;
    private final MemData data;
    private DataFTBuilder ftbuilder;

    public DataBuilder(MemData data, QueryContext qc) {
        this.data = data;
        this.qc = qc;
    }

    public DataBuilder ftpos(byte[] name, FTPosData pos, int len) {
        this.ftbuilder = new DataFTBuilder(pos, len, this.data.elemNames.put(name));
        return this;
    }

    public void build(ANode node) throws QueryException {
        this.build((ANodeList)((Object)new ANodeList().add(node)));
    }

    public void build(ANodeList nodes) throws QueryException {
        this.data.meta.update();
        int next = this.data.meta.size;
        for (ANode node : nodes) {
            next = this.addNode(node, next, -1);
        }
        DataBuilder.limit(this.data.elemNames.size(), 32768, "distinct element names");
        DataBuilder.limit(this.data.attrNames.size(), 32768, "distinct attribute names");
        DataBuilder.limit(this.data.nspaces.size(), 256, "distinct namespaces");
        if (next < 0) {
            DataBuilder.limit(0, 0, "nodes");
        }
    }

    private static void limit(int value, int limit, String message) throws QueryException {
        if (value >= limit) {
            throw QueryError.BASEX_LIMIT_X_X.get(null, message, limit);
        }
    }

    private int addNode(ANode node, int pre, int par) {
        if (this.qc != null) {
            this.qc.checkStop();
        }
        switch ((NodeType)node.type) {
            case DOCUMENT_NODE: {
                return this.addDoc(node, pre);
            }
            case ELEMENT: {
                return this.addElem(node, pre, par);
            }
            case TEXT: {
                return this.addText(node, pre, par);
            }
            case ATTRIBUTE: {
                return this.addAttr(node, pre, par);
            }
            case COMMENT: {
                return this.addComm(node, pre, par);
            }
        }
        return this.addPI(node, pre, par);
    }

    private int addDoc(ANode node, int pre) {
        int size = DataBuilder.size(node, false);
        this.data.doc(size, node.baseURI());
        int last = this.data.meta.size;
        this.data.insert(last);
        int next = pre + 1;
        for (ANode child : node.childIter()) {
            next = this.addNode(child, next, pre);
        }
        if (size != next - pre) {
            this.data.size(last, 0, next - pre);
        }
        return next;
    }

    private int addAttr(ANode node, int pre, int par) {
        int last = this.data.meta.size;
        QNm qname = node.qname();
        byte[] prefix = qname.prefix();
        byte[] uri = qname.uri();
        int uriId = uri.length == 0 || Token.eq(prefix, Token.XML) ? 0 : (par == -1 ? this.data.nspaces.add(last, prefix, uri, this.data) : this.data.nspaces.uriId(uri));
        int nameId = this.data.attrNames.put(qname.string());
        this.data.attr(pre - par, nameId, node.string(), uriId);
        this.data.insert(last);
        return pre + 1;
    }

    private int addText(ANode node, int pre, int par) {
        ArrayList<DataFTBuilder.DataFTMarker> marks;
        int dist = pre - par;
        ArrayList<DataFTBuilder.DataFTMarker> arrayList = marks = this.ftbuilder != null ? this.ftbuilder.build(node) : null;
        if (marks == null) {
            this.addText(node.string(), dist);
            return pre + 1;
        }
        int uriId = this.data.nspaces.uriIdForPrefix(Token.EMPTY, true);
        int ts = marks.size();
        for (DataFTBuilder.DataFTMarker marker : marks) {
            if (marker.mark) {
                this.data.elem(dist++, this.ftbuilder.name(), 1, 2, uriId, false);
                this.data.insert(this.data.meta.size);
                ++ts;
            }
            this.addText(marker.token, marker.mark ? 1 : dist);
            ++dist;
        }
        return pre + ts;
    }

    private void addText(byte[] text, int dist) {
        this.data.text(dist, text, 2);
        this.data.insert(this.data.meta.size);
    }

    private int addPI(ANode node, int pre, int par) {
        byte[] value = Token.trim(Token.concat(node.name(), Token.SPACE, node.string()));
        this.data.text(pre - par, value, 5);
        this.data.insert(this.data.meta.size);
        return pre + 1;
    }

    private int addComm(ANode node, int pre, int par) {
        this.data.text(pre - par, node.string(), 4);
        this.data.insert(this.data.meta.size);
        return pre + 1;
    }

    private int addElem(ANode node, int pre, int par) {
        boolean nsFlag;
        int last = this.data.meta.size;
        Atts ns = par == -1 ? node.nsScope(null) : node.namespaces();
        this.data.nspaces.open(last, ns);
        QNm qname = node.qname();
        int nameId = this.data.elemNames.put(qname.string());
        int size = DataBuilder.size(node, false);
        int asize = DataBuilder.size(node, true);
        byte[] uri = qname.uri();
        int uriId = this.data.nspaces.uriId(uri);
        boolean bl = nsFlag = !ns.isEmpty();
        if (uriId == 0 && uri.length != 0) {
            uriId = this.data.nspaces.add(last, qname.prefix(), uri, this.data);
            nsFlag = true;
        }
        this.data.elem(pre - par, nameId, asize, size, uriId, nsFlag);
        this.data.insert(last);
        int cPre = pre + 1;
        for (ANode attr : node.attributeIter()) {
            cPre = this.addAttr(attr, cPre, pre);
        }
        for (ANode child : node.childIter()) {
            cPre = this.addNode(child, cPre, pre);
        }
        this.data.nspaces.close(last);
        if (size != cPre - pre) {
            this.data.size(last, 1, cPre - pre);
        }
        return cPre;
    }

    private static int size(ANode node, boolean att) {
        if (node instanceof DBNode) {
            DBNode dbnode = (DBNode)node;
            Data data = dbnode.data();
            int kind = node.kind();
            int pre = dbnode.pre();
            return att ? data.attSize(pre, kind) : data.size(pre, kind);
        }
        int size = 1;
        BasicNodeIter iter = node.attributeIter();
        while (iter.next() != null) {
            ++size;
        }
        if (!att) {
            for (ANode child : node.childIter()) {
                size += DataBuilder.size(child, false);
            }
        }
        return size;
    }

    public static ANode stripNamespace(ANode node, byte[] uri, Context ctx) throws QueryException {
        if (!node.type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE)) {
            return node;
        }
        MemData data = new MemData(ctx.options);
        DataBuilder db = new DataBuilder(data, null);
        db.build(node);
        boolean del = true;
        int size = data.meta.size;
        for (int pre = 0; pre < size; ++pre) {
            byte[] u;
            int kind = data.kind(pre);
            if (kind != 1 && kind != 3 || (u = data.nspaces.uri(data.uriId(pre, kind))) == null || !Token.eq(u, uri)) continue;
            byte[] nm = data.name(pre, kind);
            if (Token.prefix(nm).length == 0) {
                if (kind != 1) continue;
                data.update(pre, 1, nm, Token.EMPTY);
                data.nsFlag(pre, false);
                continue;
            }
            del = false;
        }
        if (del) {
            data.nspaces.delete(uri);
        }
        return new DBNode(data);
    }

    public static ANode stripNamespaces(ANode node, TokenSet prefixes, Context ctx, InputInfo info) throws QueryException {
        if (!node.type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE)) {
            return node;
        }
        MemData data = new MemData(ctx.options);
        DataBuilder db = new DataBuilder(data, null);
        db.build(node);
        TokenSet atts = new TokenSet();
        TokenSet uris = new TokenSet();
        TokenSet keep = new TokenSet();
        int size = data.meta.size;
        for (int pre = 0; pre < size; ++pre) {
            boolean attr;
            int kind = data.kind(pre);
            boolean bl = attr = kind == 3;
            if (!attr) {
                atts.clear();
            }
            if (!attr && kind != 1) continue;
            byte[] name = data.name(pre, kind);
            byte[] uri = data.nspaces.uri(data.uriId(pre, kind));
            if (uri != null) {
                uris.put(uri);
                byte[] prefix = Token.prefix(name);
                if (prefixes.isEmpty() || prefixes.contains(prefix)) {
                    name = Token.local(name);
                    data.update(pre, kind, name, Token.EMPTY);
                    if (!attr) {
                        data.nsFlag(pre, false);
                    }
                } else {
                    keep.put(uri);
                }
            }
            if (!attr || atts.add(name)) continue;
            throw QueryError.BASEX_STRIP_X.get(info, new Object[]{Token.local(name)});
        }
        for (byte[] uri : uris) {
            if (keep.contains(uri)) continue;
            data.nspaces.delete(uri);
        }
        return new DBNode(data);
    }
}

