/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.name;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.name.NameUpdate;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class DBCreate
extends NameUpdate {
    private final DBNew newDocs;
    private final MainOptions options;
    private DataClip clip;

    public DBCreate(String name, NewInput[] inputs, HashMap<String, String> qopts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBCREATE, name, qc, info);
        ArrayList supported = new ArrayList();
        Collections.addAll(supported, MainOptions.INDEXING);
        Collections.addAll(supported, MainOptions.PARSING);
        DBOptions dbopts = new DBOptions(qopts, supported, info);
        this.options = dbopts.assignTo(new MainOptions(qc.context.options, false));
        this.newDocs = new DBNew(qc, this.options, info, inputs);
    }

    @Override
    public void prepare() throws QueryException {
        this.clip = this.newDocs.prepare(this.name, true);
    }

    @Override
    public void apply() throws QueryException {
        try {
            this.close();
            Data data = CreateDB.create(this.name, Parser.emptyParser(this.options), this.qc.context, this.options);
            if (this.clip != null) {
                data.startUpdate(this.options);
                try {
                    this.newDocs.addTo(data);
                    Optimize.optimize(data, null);
                }
                finally {
                    data.finishUpdate(this.options);
                }
            }
            Close.close(data, this.qc.context);
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
        finally {
            if (this.clip != null) {
                this.clip.finish();
            }
        }
    }

    @Override
    public String operation() {
        return "created";
    }

    public String toString() {
        return Util.className(this) + "[" + this.newDocs.inputs + "]";
    }
}

