/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class DBPutBinary
extends DBUpdate {
    private final TokenObjMap<Item> paths = new TokenObjMap();

    public DBPutBinary(Data data, Item item, String path, InputInfo info) {
        super(UpdateType.DBPUTBINARY, data, info);
        this.paths.put(Token.token(path), item);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.paths) {
            IOFile bin = this.data.meta.file(Token.string(path), ResourceType.BINARY);
            if (bin.isDir()) {
                bin.delete();
            }
            bin.parent().md();
            try {
                BufferInput bi = this.paths.get(path).input(this.info);
                try {
                    bin.write(bi);
                }
                finally {
                    if (bi == null) continue;
                    bi.close();
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.UPDBPUT_X.get(this.info, new Object[]{path});
            }
        }
    }

    @Override
    public void merge(Update update) throws QueryException {
        TokenObjMap<Item> store = ((DBPutBinary)update).paths;
        for (byte[] path : store) {
            if (this.paths.contains(path)) {
                throw QueryError.DB_CONFLICT5_X.get(this.info, new Object[]{path});
            }
            this.paths.put(path, store.get(path));
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }
}

