/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CElem;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.constr.CNode;
import org.basex.query.expr.constr.CPI;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.RenameNode;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Rename
extends Update {
    public Rename(StaticContext sc, InputInfo info, Expr trg, Expr name) {
        super(sc, info, trg, name);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        boolean attr;
        CName ex;
        Iter iter = this.exprs[0].iter(qc);
        Item item = iter.next();
        if (item == null) {
            throw QueryError.UPSEQEMP_X.get(this.info, Util.className(this));
        }
        Item item2 = iter.next();
        if (item2 != null) {
            throw QueryError.UPWRTRGSINGLE_X.get(this.info, ValueBuilder.concat(item, item2, qc));
        }
        Type type = item.type;
        if (type == NodeType.ELEMENT) {
            ex = new CElem(this.sc, this.info, false, this.exprs[1], new Atts(), new Expr[0]);
        } else if (type == NodeType.ATTRIBUTE) {
            ex = new CAttr(this.sc, this.info, false, this.exprs[1], Empty.VALUE);
        } else if (type == NodeType.PROCESSING_INSTRUCTION) {
            ex = new CPI(this.sc, this.info, false, this.exprs[1], (Expr)Empty.VALUE);
        } else {
            throw QueryError.UPWRTRGTYP_X.get(this.info, item);
        }
        QNm newName = ((ANode)((CNode)ex).item(qc, this.info)).qname();
        ANode target = (ANode)item;
        Type tt = target.type;
        boolean elem = tt == NodeType.ELEMENT;
        boolean bl = attr = tt == NodeType.ATTRIBUTE;
        if (elem || attr) {
            byte[] newPrefix = newName.prefix();
            byte[] newUri = newName.uri();
            if (elem || newPrefix.length > 0) {
                Atts nspaces = target.nsScope(this.sc);
                int ns = nspaces.size();
                for (int n = 0; n < ns; ++n) {
                    byte[] prefix = nspaces.name(n);
                    byte[] uri = nspaces.value(n);
                    if (!Token.eq(prefix, newPrefix) || Token.eq(uri, newUri)) continue;
                    throw QueryError.UPNSCONFL_X_X.get(this.info, newName, new QNm(prefix, uri));
                }
            }
        }
        Updates updates = qc.updates();
        DBNode dbn = updates.determineDataRef(target, qc);
        updates.add(new RenameNode(dbn.pre(), dbn.data(), this.info, newName), qc);
        return Empty.VALUE;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Rename(this.sc, this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Rename && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("rename").token("node").token(this.exprs[0]).token("as").token(this.exprs[1]);
    }
}

