/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import org.basex.core.locks.LockList;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;

public final class LockVisitor
extends ASTVisitor {
    private final IdentityHashMap<Scope, Object> funcs = new IdentityHashMap();
    private final LockList ll;
    private int level;

    public LockVisitor(LockList ll, boolean root) {
        this.ll = ll;
        this.level = root ? 0 : 1;
    }

    @Override
    public boolean lock(String lock) {
        boolean local;
        boolean bl = local = lock != null;
        if (local && (lock != "internal:context" || this.level == 0)) {
            this.ll.add(lock);
        }
        return local;
    }

    @Override
    public boolean lock(Supplier<ArrayList<String>> list) {
        for (String lock : list.get()) {
            if (this.lock(lock)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void enterFocus() {
        ++this.level;
    }

    @Override
    public void exitFocus() {
        --this.level;
    }

    @Override
    public boolean staticVar(StaticVar var) {
        if (this.funcs.containsKey(var)) {
            return true;
        }
        this.funcs.put(var, null);
        return var.visit(this);
    }

    @Override
    public boolean staticFuncCall(StaticFuncCall call) {
        return this.func(call.func());
    }

    @Override
    public boolean inlineFunc(Scope scope) {
        this.enterFocus();
        boolean ac = scope.visit(this);
        this.exitFocus();
        return ac;
    }

    @Override
    public boolean funcItem(FuncItem func) {
        return this.func(func);
    }

    private boolean func(Scope scope) {
        if (this.funcs.containsKey(scope)) {
            return true;
        }
        this.funcs.put(scope, null);
        this.enterFocus();
        boolean ac = scope.visit(this);
        this.exitFocus();
        return ac;
    }
}

