/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import java.util.ArrayList;
import java.util.concurrent.ForkJoinPool;
import org.basex.core.jobs.JobException;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.xquery.TaskContext;
import org.basex.query.func.xquery.TaskOptions;
import org.basex.query.func.xquery.XQueryTask;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class XQueryForkJoin
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value functions = this.arg(0).value(qc);
        TaskOptions options = this.toOptions(this.arg(1), new TaskOptions(), true, qc);
        long size = functions.size();
        if (size == 0L) {
            return Empty.VALUE;
        }
        ArrayList<FItem> list = new ArrayList<FItem>((int)size);
        for (Item function : functions) {
            if (!(function instanceof FItem) || ((FItem)function).arity() != 0) {
                throw QueryError.ZEROFUNCS_X_X.get(this.info, function.type, function);
            }
            list.add(this.checkUp((FItem)function, false, this.sc));
        }
        if (size == 1L) {
            return ((FItem)list.get(0)).invoke(qc, this.info, new Value[0]);
        }
        ForkJoinPool pool = new ForkJoinPool(options.parallel());
        TaskContext tc = new TaskContext(list, options, qc, this.info);
        try {
            Value value = pool.invoke(new XQueryTask(tc));
            return value;
        }
        catch (Exception ex) {
            Throwable e = Util.rootException(ex);
            if (e instanceof QueryException) {
                throw (QueryException)e;
            }
            if (e instanceof JobException) {
                throw (JobException)e;
            }
            throw QueryError.XQUERY_UNEXPECTED_X.get(this.info, e);
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Boolean results;
        Expr functions = this.arg(0);
        Expr options = this.arg(1);
        SeqType st = functions.seqType();
        if (st.zero()) {
            return functions;
        }
        if (st.one()) {
            return new DynFuncCall(this.info, this.sc, functions, new Expr[0]).optimize(cc);
        }
        Boolean bl = options == Empty.UNDEFINED ? Boolean.TRUE : (results = options instanceof Value ? this.toOptions(this.arg(1), new TaskOptions(), true, cc.qc).get(TaskOptions.RESULTS) : null);
        if (results == Boolean.TRUE) {
            Type type = st.type;
            if (type instanceof FuncType) {
                SeqType dt = ((FuncType)type).declType;
                this.exprType.assign(dt.with(dt.occ.multiply(st.occ)));
            }
        } else if (results == Boolean.FALSE) {
            this.exprType.assign(SeqType.EMPTY_SEQUENCE_Z);
        }
        return this;
    }
}

