/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.proc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.basex.core.jobs.JobException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.proc.ProcOptions;
import org.basex.query.func.proc.ProcResult;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

abstract class ProcFn
extends StandardFunc {
    static final QNm Q_RESULT = new QNm("result");
    static final QNm Q_OUTPUT = new QNm("output");
    static final QNm Q_ERROR = new QNm("error");
    static final QNm Q_CODE = new QNm("code");

    ProcFn() {
    }

    final ProcResult exec(QueryContext qc, boolean fork) throws QueryException {
        Process proc;
        Charset cs;
        Item item;
        String command = this.toString(this.arg(0), qc);
        StringList args = (StringList)((Object)new StringList().add(command));
        Iter iter = this.arg(1).iter(qc);
        while ((item = qc.next(iter)) != null) {
            args.add(this.toString(item));
        }
        ProcOptions options = this.toOptions(this.arg(2), new ProcOptions(), true, qc);
        String encoding = options.get(ProcOptions.ENCODING);
        try {
            cs = Charset.forName(encoding);
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw QueryError.PROC_ENCODING_X.get(this.info, encoding);
        }
        long seconds = options.get(ProcOptions.TIMEOUT).intValue();
        String dir = options.get(ProcOptions.DIR);
        String input = options.get(ProcOptions.INPUT);
        ProcResult result = new ProcResult();
        ProcessBuilder pb = new ProcessBuilder((String[])args.finish());
        if (dir != null) {
            pb.directory(this.toPath(dir).toFile());
        }
        try {
            proc = pb.start();
        }
        catch (IOException ex) {
            result.exception(ex);
            return result;
        }
        if (fork) {
            return null;
        }
        Thread outt = ProcFn.reader(proc.getInputStream(), result.output, cs, result);
        Thread errt = ProcFn.reader(proc.getErrorStream(), result.error, cs, result);
        outt.start();
        errt.start();
        Thread thread = new Thread(() -> {
            try {
                if (input != null) {
                    try (OutputStream os = proc.getOutputStream();){
                        os.write(Token.token(input));
                    }
                }
                proc.waitFor();
                outt.join();
                errt.join();
            }
            catch (IOException ex) {
                result.exception(ex);
            }
            catch (InterruptedException ex) {
                result.error.add(Util.message(ex));
            }
        });
        thread.start();
        Performance perf = new Performance();
        try {
            while (thread.isAlive()) {
                qc.checkStop();
                if (seconds > 0L && perf.ns(false) / 1000000000L >= seconds) {
                    thread.interrupt();
                    throw QueryError.PROC_TIMEOUT.get(this.info, new Object[0]);
                }
                Performance.sleep(10L);
            }
            result.code = proc.exitValue();
            return result;
        }
        catch (JobException ex) {
            thread.interrupt();
            throw ex;
        }
    }

    private static Thread reader(InputStream in, TokenBuilder tb, Charset cs, ProcResult pr) {
        InputStreamReader isr = new InputStreamReader(in, cs);
        BufferedReader br = new BufferedReader(isr);
        return new Thread(() -> {
            try {
                int b;
                while ((b = br.read()) != -1) {
                    tb.add(b);
                }
            }
            catch (IOException ex) {
                pr.exception = ex;
            }
        });
    }
}

