/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class MapPut
extends StandardFunc {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        XQMap map = this.toMap(this.arg(0), qc);
        Item key = this.toAtomItem(this.arg(1), qc);
        Value value = this.arg(2).value(qc);
        return map.put(key, value, this.info);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        AtomType typeKey;
        Expr map = this.arg(0);
        Expr key = this.arg(1);
        Expr value = this.arg(2);
        if (map == XQMap.empty()) {
            return cc.function(Function._MAP_ENTRY, this.info, key, value);
        }
        Type type = map.seqType().type;
        if (type instanceof MapType && (typeKey = key.seqType().type.atomic()) != null) {
            SeqType st = value.seqType();
            if (!(map instanceof XQMap) || ((XQMap)map).mapSize() != 0) {
                MapType mt = (MapType)type;
                typeKey = mt.keyType().union(typeKey);
                st = mt.declType.union(value.seqType());
            }
            this.exprType.assign(MapType.get(typeKey, st));
        }
        return this;
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        this.arg(1, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc));
    }
}

