/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.io.IOContent;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.AModule;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.StaticDecl;
import org.basex.query.scope.StaticScope;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class XQDoc
extends Inspect {
    private static final byte[] XQDOC_URI = Token.token("http://www.xqdoc.org/1.0");
    private static final byte[] XQDOC_PREFIX = Token.token("xqdoc");

    XQDoc(QueryContext qc, InputInfo info) {
        super(qc, info);
    }

    @Override
    public FNode parse(IOContent content) throws QueryException {
        Object prefix3;
        Object prefix22;
        AModule module = this.parseModule(content);
        FBuilder xqdoc = this.element("xqdoc").declareNS();
        FBuilder control = this.element("control");
        control.add(this.element("date").add(this.qc.dateTime().datm.string(this.info)));
        control.add(this.element("version").add("1.1"));
        xqdoc.add(control);
        String type = module instanceof LibraryModule ? "library" : "main";
        FBuilder mod = this.element("module").add(Q_TYPE, type);
        if (module instanceof LibraryModule) {
            mod.add(this.element("uri").add(module.sc.module.uri()));
            mod.add(this.element("name").add(content.name()));
        } else {
            mod.add(this.element("uri").add(content.name()));
        }
        this.comment(module, mod);
        xqdoc.add(mod);
        FBuilder imports = this.element("imports");
        for (byte[] uri : module.modules) {
            imports.add(this.element("import").add(Q_TYPE, "library").add(this.element("uri").add(uri)));
        }
        xqdoc.add(imports);
        FBuilder namespaces = this.element("namespaces");
        TokenMap nsCache = new TokenMap();
        for (Object prefix22 : module.namespaces) {
            nsCache.put((byte[])prefix22, module.namespaces.get((byte[])prefix22));
        }
        QueryBiConsumer<QNm, StaticDecl> addNs = (name, sd) -> {
            if (name.hasPrefix()) {
                nsCache.put(name.prefix(), name.uri());
            }
            for (Ann ann : sd.anns) {
                byte[] uri = ann.name().uri();
                if (uri.length <= 0) continue;
                nsCache.put(NSGlobal.prefix(uri), uri);
            }
        };
        prefix22 = module.vars.iterator();
        while (prefix22.hasNext()) {
            StaticVar sv = (StaticVar)prefix22.next();
            addNs.accept(sv.name, sv);
        }
        for (StaticFunc sf : module.funcs) {
            addNs.accept(sf.funcName(), sf);
        }
        for (Object prefix3 : nsCache) {
            FBuilder namespace = this.element("namespace");
            namespace.add(Q_PREFIX, (byte[])prefix3).add(Q_URI, nsCache.get((byte[])prefix3));
            namespaces.add(namespace);
        }
        xqdoc.add(namespaces);
        FBuilder variables = this.element("variables");
        prefix3 = module.vars.iterator();
        while (prefix3.hasNext()) {
            StaticVar sv = (StaticVar)prefix3.next();
            FBuilder variable = this.element("variable");
            variable.add(this.element("name").add(sv.name.string()));
            this.comment(sv, variable);
            this.annotations(sv.anns, variable);
            this.type(sv.seqType(), variable);
            variables.add(variable);
        }
        xqdoc.add(variables);
        FBuilder functions = this.element("functions");
        for (StaticFunc sf : module.funcs) {
            int al = sf.arity();
            byte[] name2 = sf.funcName().string();
            FuncType tp = sf.funcType();
            FBuilder function = this.element("function").add(Q_ARITY, al);
            this.comment(sf, function);
            function.add(this.element("name").add(name2));
            this.annotations(sf.anns, function);
            QueryString qs = new QueryString();
            qs.token("declare").token(sf.anns).token("function").token(name2).token('(');
            for (int a = 0; a < al; ++a) {
                Var var = sf.params[a];
                if (a > 0) {
                    qs.token(", ");
                }
                qs.concat("$", var.name.string()).token("as").token(tp.argTypes[a]);
            }
            qs.token(')').token("as").token(tp.declType);
            if (sf.expr == null) {
                qs.token(Q_EXTERNAL);
            }
            function.add(this.element("signature").add(qs));
            if (al != 0) {
                FBuilder fparameters = this.element("parameters");
                for (int a = 0; a < al; ++a) {
                    FBuilder fparameter = this.element("parameter");
                    fparameter.add(this.element("name").add(sf.params[a].name.string()));
                    this.type(tp.argTypes[a], fparameter);
                    fparameters.add(fparameter);
                }
                function.add(fparameters);
            }
            FBuilder rtrn = this.element("return");
            this.type(sf.seqType(), rtrn);
            functions.add(function.add(rtrn));
        }
        xqdoc.add(functions);
        return xqdoc.finish();
    }

    @Override
    protected FBuilder element(String name) {
        return FElem.build(new QNm(XQDOC_PREFIX, name, XQDOC_URI));
    }

    @Override
    protected FBuilder element(byte[] name) {
        return Token.eq(name, DOC_TAGS) ? this.element(Token.string(name)) : this.element("custom").add(Q_TAG, name);
    }

    private void comment(StaticScope scope, FBuilder parent) throws QueryException {
        TokenObjMap<TokenList> map = scope.doc();
        if (map != null) {
            FBuilder comment = this.element("comment");
            this.comment(map, comment);
            parent.add(comment);
        }
    }

    private void annotations(AnnList anns, FBuilder parent) throws QueryException {
        if (!anns.isEmpty()) {
            FBuilder annotations = this.element("annotations");
            this.annotation(anns, annotations, false);
            parent.add(annotations);
        }
    }

    private void type(SeqType st, FBuilder parent) {
        if (st == null) {
            return;
        }
        FBuilder type = this.element("type").add(st.typeString());
        String occ = st.occ.toString();
        if (!occ.isEmpty()) {
            type.add(Q_OCCURRENCE, occ);
        }
        parent.add(type);
    }
}

