/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.util.Collections;
import java.util.HashSet;
import org.basex.io.IOContent;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;

public final class InspectFunctions
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (!this.defined(0)) {
            ValueBuilder vb = new ValueBuilder(qc);
            for (StaticFunc sf : qc.functions.funcs()) {
                vb.add(Functions.getUser(sf, qc, sf.sc, this.info));
            }
            return vb.value(this);
        }
        IOContent content = this.toContent(this.toString(this.arg(0), qc), qc);
        Value funcs = qc.resources.functions(content.path());
        if (funcs != null) {
            return funcs;
        }
        HashSet old = new HashSet();
        Collections.addAll(old, qc.functions.funcs());
        try {
            qc.parse(content.toString(), content.path());
            qc.functions.compileAll(new CompileContext(qc, true));
        }
        catch (QueryException ex) {
            throw QueryError.INSPECT_PARSE_X.get(this.info, ex);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (StaticFunc sf : qc.functions.funcs()) {
            if (old.contains(sf)) continue;
            vb.add(Functions.getUser(sf, qc, sf.sc, this.info));
        }
        funcs = vb.value(this);
        qc.resources.addFunctions(content.path(), funcs);
        return funcs;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        if (!this.defined(0)) {
            cc.qc.functions.compileAll(cc);
        }
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock((String)null) && super.accept(visitor);
    }
}

