/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.hash;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.B64Lazy;
import org.basex.query.value.item.Item;
import org.basex.util.Util;

abstract class HashFn
extends StandardFunc {
    HashFn() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final B64 hash(String algo, QueryContext qc) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            if (!(value instanceof B64Lazy)) return B64.get(md.digest(this.toBytes(value)));
            try (BufferInput bi = value.input(this.info);){
                byte[] tmp = new byte[4096];
                while (true) {
                    qc.checkStop();
                    int n = bi.read(tmp);
                    if (n == -1) {
                        B64 b64 = B64.get(md.digest());
                        return b64;
                    }
                    md.update(tmp, 0, n);
                }
            }
            catch (IOException ex) {
                throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Util.debug(ex);
            throw QueryError.HASH_ALGORITHM_X.get(this.info, algo);
        }
    }
}

