/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.ft;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ft.FTContent;
import org.basex.query.expr.ft.FTDistance;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTOrder;
import org.basex.query.expr.ft.FTScope;
import org.basex.query.expr.ft.FTWindow;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.ft.FtIndexOptions;
import org.basex.query.value.item.Int;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTDistanceOptions;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTScopeOptions;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.FTWindowOptions;
import org.basex.util.options.Options;

abstract class FtAccess
extends StandardFunc {
    FtAccess() {
    }

    final FTOpt ftOpt(FtIndexOptions opts, QueryContext qc) throws QueryException {
        FTOpt opt = new FTOpt();
        opt.set(FTFlag.FZ, opts.get(FtIndexOptions.FUZZY));
        opt.set(FTFlag.WC, opts.get(FtIndexOptions.WILDCARDS));
        if (opt.is(FTFlag.FZ) && opt.is(FTFlag.WC)) {
            throw QueryError.FT_OPTIONS.get(this.info, this);
        }
        opt.errors = opts.contains(FtIndexOptions.ERRORS) ? opts.get(FtIndexOptions.ERRORS) : qc.context.options.get(MainOptions.LSERROR);
        return opt;
    }

    final FTExpr ftExpr(FTExpr expr, FtIndexOptions opts) {
        FTExpr ex = expr;
        if (opts != null) {
            FTUnit unit;
            Options fopts;
            if (opts.get(FtIndexOptions.ORDERED).booleanValue()) {
                ex = new FTOrder(this.info, ex);
            }
            if (opts.contains(FtIndexOptions.DISTANCE)) {
                fopts = opts.get(FtIndexOptions.DISTANCE);
                Int min = Int.get(fopts.get(FTDistanceOptions.MIN).intValue());
                Int max = Int.get(fopts.get(FTDistanceOptions.MAX).intValue());
                FTUnit unit2 = fopts.get(FTDistanceOptions.UNIT);
                ex = new FTDistance(this.info, ex, min, max, unit2);
            }
            if (opts.contains(FtIndexOptions.WINDOW)) {
                fopts = opts.get(FtIndexOptions.WINDOW);
                Int size = Int.get(fopts.get(FTWindowOptions.SIZE).intValue());
                unit = fopts.get(FTWindowOptions.UNIT);
                ex = new FTWindow(this.info, ex, size, unit);
            }
            if (opts.contains(FtIndexOptions.SCOPE)) {
                fopts = opts.get(FtIndexOptions.SCOPE);
                boolean same = fopts.get(FTScopeOptions.SAME);
                unit = fopts.get(FTScopeOptions.UNIT).unit();
                ex = new FTScope(this.info, ex, same, unit);
            }
            if (opts.contains(FtIndexOptions.CONTENT)) {
                FTContents content = opts.get(FtIndexOptions.CONTENT);
                ex = new FTContent(this.info, ex, content);
            }
        }
        return ex;
    }
}

