/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.regex.parse.ParseException;
import org.basex.query.util.regex.parse.RegExParser;
import org.basex.query.util.regex.parse.TokenMgrError;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

abstract class RegEx
extends StandardFunc {
    static final byte[] REGEX_CHARS = Token.token("\\^$.|?*+()[]{}");
    private final TokenObjMap<RegExpr> patterns = new TokenObjMap();

    RegEx() {
    }

    final Pattern pattern(byte[] pattern, Expr flags, QueryContext qc, boolean check) throws QueryException {
        return this.regExpr((byte[])pattern, (Expr)flags, (QueryContext)qc, (boolean)check).pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RegExpr regExpr(byte[] pattern, Expr flags, QueryContext qc, boolean check) throws QueryException {
        byte[] modifiers;
        byte[] byArray = modifiers = flags != null ? this.toTokenOrNull(flags, qc) : null;
        if (modifiers == null) {
            modifiers = Token.EMPTY;
        }
        byte[] key = Token.concat(pattern, Character.valueOf('\b'), modifiers);
        TokenObjMap<RegExpr> tokenObjMap = this.patterns;
        synchronized (tokenObjMap) {
            RegExpr regExpr = this.patterns.get(key);
            if (regExpr == null) {
                regExpr = this.parse(pattern, modifiers, check);
                this.patterns.put(key, regExpr);
            }
            return regExpr;
        }
    }

    static int patternChar(byte[] pattern) {
        int sl = pattern.length;
        int separator = sl > 0 && Token.cl(pattern, 0) == sl ? Token.cp(pattern, 0) : -1;
        return separator == -1 || Token.contains(REGEX_CHARS, separator) ? -1 : separator;
    }

    private RegExpr parse(byte[] regex, byte[] modifiers, boolean check) throws QueryException {
        int flags = 0;
        boolean strip = false;
        boolean java = false;
        for (byte mod : modifiers) {
            if (mod == 105) {
                flags |= 0x42;
                continue;
            }
            if (mod == 109) {
                flags |= 8;
                continue;
            }
            if (mod == 115) {
                flags |= 0x20;
                continue;
            }
            if (mod == 113) {
                flags |= 0x10;
                continue;
            }
            if (mod == 120) {
                strip = true;
                continue;
            }
            if (mod == 106 || mod == 33) {
                java = true;
                continue;
            }
            if (mod == 59) continue;
            throw QueryError.REGFLAG_X.get(this.info, Character.valueOf((char)mod));
        }
        try {
            Pattern pattern;
            int groups = 0;
            if (java || (flags & 0x10) != 0) {
                pattern = Pattern.compile(Token.string(regex), flags);
            } else {
                RegExParser parser = new RegExParser(regex, strip, (flags & 0x20) != 0, (flags & 8) != 0);
                String string = parser.parse().toString();
                pattern = Pattern.compile(string, flags);
                if (check) {
                    Pattern p;
                    Pattern pattern2 = p = (pattern.flags() & 8) == 0 ? pattern : Pattern.compile(pattern.pattern());
                    if (p.matcher("").matches()) {
                        throw QueryError.REGEMPTY_X.get(this.info, string);
                    }
                }
                groups = parser.groups();
            }
            RegExpr regExpr = new RegExpr();
            regExpr.pattern = pattern;
            regExpr.groups = groups;
            return regExpr;
        }
        catch (PatternSyntaxException | ParseException | TokenMgrError ex) {
            Util.debug(ex);
            throw QueryError.REGINVALID_X.get(this.info, new Object[]{regex});
        }
    }

    static class RegExpr {
        Pattern pattern;
        int groups;

        RegExpr() {
        }
    }
}

