/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.Seq;
import org.basex.util.Token;
import org.basex.util.list.LongList;

public final class FnStringToCodepoints
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        AStr value = this.toZeroStr(this.arg(0), qc);
        final byte[] token = value.string(this.info);
        final int tl = token.length;
        if (tl == 0) {
            return Empty.ITER;
        }
        if (value.ascii(this.info)) {
            return new BasicIter<Int>((long)tl){

                @Override
                public Int get(long i) {
                    return Int.get(token[(int)i]);
                }

                @Override
                public Value value(QueryContext q, Expr expr) throws QueryException {
                    LongList list = new LongList(Seq.initialCapacity(this.size));
                    for (byte b : token) {
                        list.add((long)b);
                    }
                    return IntSeq.get(list);
                }
            };
        }
        return new Iter(){
            int t;

            @Override
            public Int next() {
                if (this.t == tl) {
                    return null;
                }
                int cp = Token.cp(token, this.t);
                this.t += Token.cl(token, this.t);
                return Int.get(cp);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        AStr value = this.toZeroStr(this.arg(0), qc);
        byte[] token = value.string(this.info);
        LongList list = new LongList(value.length(this.info));
        if (value.ascii(this.info)) {
            for (byte b : token) {
                list.add((long)b);
            }
        } else {
            int tl = token.length;
            for (int t = 0; t < tl; t += Token.cl(token, t)) {
                list.add((long)Token.cp(token, t));
            }
        }
        return IntSeq.get(list);
    }
}

