/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.function.IntPredicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

public class FnSlice
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        Slice slice = this.slice(input.size(), qc);
        if (slice.length == 0L) {
            return Empty.VALUE;
        }
        if (slice.reverse) {
            input = input.reverse(qc);
        }
        if (slice.step == 1L) {
            return input.subsequence(slice.start - 1L, slice.length, qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (long i = slice.start; i <= slice.end; i += slice.step) {
            vb.add(input.itemAt(i - 1L));
        }
        return vb.value();
    }

    @Override
    public Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        IntPredicate value = e -> !this.defined(e) || this.arg(e) instanceof Value;
        if (value.test(1) && value.test(2) && value.test(3)) {
            long size = input.size();
            if (size != -1L) {
                Slice slice = this.slice(size, cc.qc);
                if (slice.step == 1L) {
                    Expr arg = slice.reverse ? cc.function(Function.REVERSE, this.info, input) : input;
                    return cc.function(Function._UTIL_RANGE, this.info, arg, Int.get(slice.start), Int.get(slice.end));
                }
            }
            long start = this.toLong(1, 1L, cc.qc);
            long end = this.toLong(2, Long.MAX_VALUE, cc.qc);
            if (end == Long.MAX_VALUE && this.toLong(3, 1L, cc.qc) == 1L) {
                if (start == -1L) {
                    return cc.function(Function.FOOT, this.info, input);
                }
                if (start == 0L || start == 1L) {
                    return input;
                }
            }
        }
        this.exprType.assign(st.union(Occ.ZERO)).data(input);
        return this;
    }

    protected final Slice slice(long size, QueryContext qc) throws QueryException {
        Slice s = new Slice(size, this.toLong(1, 0L, qc), this.toLong(2, 0L, qc), this.toLong(3, 0L, qc), false);
        if (s.step < 0L) {
            s = new Slice(size, -s.start, -s.end, -s.step, true);
        }
        s.start = Math.max(1L, s.start);
        s.end = Math.min(size, s.end);
        s.length = s.end < 1L || s.start > size || s.start > s.end ? 0L : s.end - s.start + 1L;
        return s;
    }

    private long toLong(int i, long dflt, QueryContext qc) throws QueryException {
        Item item = this.arg(i).atomItem(qc, this.info);
        return item.isEmpty() ? dflt : this.toLong(item);
    }

    public static final class Slice {
        public final boolean reverse;
        public final long step;
        public long length;
        public long start;
        public long end;

        private Slice(long size, long start, long end, long step, boolean reverse) {
            long l = start > 0L ? start : (this.start = start < 0L ? size + start + 1L : 1L);
            long l2 = end > 0L ? end : (this.end = end < 0L ? size + end + 1L : size);
            this.step = step != 0L ? step : (this.start <= this.end ? 1L : -1L);
            this.reverse = reverse;
        }

        public String toString() {
            return Util.className(this) + "[start:" + this.start + ", end:" + this.end + ", step:" + this.step + ", reverse:" + this.reverse + ",length:" + this.length + "]";
        }
    }
}

