/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnResolveUri
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] uri = this.toTokenOrNull(this.arg(0), qc);
        byte[] base = this.toTokenOrNull(this.arg(1), qc);
        if (uri == null) {
            return Empty.VALUE;
        }
        Uri u = Uri.get(uri);
        if (!u.isValid()) {
            throw QueryError.URIARG_X.get(this.info, u);
        }
        if (u.isAbsolute()) {
            return u;
        }
        Uri b = base == null ? this.sc.baseURI() : Uri.get(base);
        byte[] string = b.string();
        if (!b.isValid() || !b.isAbsolute() || Token.contains(string, 35) || !Token.contains(string, 47)) {
            throw QueryError.URIARG_X.get(this.info, b);
        }
        return b.resolve(u, this.info);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optFirst();
    }
}

