/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.RegEx;
import org.basex.query.util.Flag;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FnReplace
extends RegEx {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        FItem action;
        byte[] value = this.toZeroToken(this.arg(0), qc);
        byte[] pattern = this.toToken(this.arg(1), qc);
        byte[] replacement = this.toZeroToken(this.arg(2), qc);
        Expr flags = this.defined(3) ? this.arg(3) : null;
        FItem fItem = action = this.defined(4) ? this.toFunction(this.arg(4), 2, qc) : null;
        if (flags == null) {
            int sp = FnReplace.patternChar(pattern);
            int rp = FnReplace.patternChar(replacement);
            if (sp != -1 && rp != -1) {
                return Str.get(Token.replace(value, sp, rp));
            }
        }
        RegEx.RegExpr regExpr = this.regExpr(pattern, flags, qc, true);
        String replace = Token.string(replacement);
        if (action == null && (regExpr.pattern.flags() & 0x10) == 0) {
            int rl = replacement.length;
            for (int r = 0; r < rl; ++r) {
                byte n;
                byte by = n = r + 1 == rl ? (byte)0 : replacement[r + 1];
                if (replacement[r] == 92) {
                    if (n != 92 && n != 36) {
                        throw QueryError.REGBACKSLASH_X.get(this.info, new Object[]{replacement});
                    }
                    ++r;
                    continue;
                }
                if (replacement[r] != 36 || r != 0 && replacement[r - 1] == 92 || Token.digit(n)) continue;
                throw QueryError.REGDOLLAR_X.get(this.info, new Object[]{replacement});
            }
            if (Strings.contains(replace, '$')) {
                StringBuilder sb = new StringBuilder();
                int sl = replace.length();
                int s = 0;
                while (s < sl) {
                    int i = replace.indexOf(36, s);
                    if (i == -1) {
                        sb.append(replace, s, sl);
                        s = sl;
                        continue;
                    }
                    if (i == 0 || replace.charAt(i - 1) != '\\') {
                        int n;
                        sb.append(replace, s, i);
                        s = ++i;
                        if (i < sl && Character.isDigit(replace.charAt(i))) {
                            ++i;
                        }
                        if ((n = Integer.parseInt(replace.substring(s, i))) <= regExpr.groups) {
                            sb.append('$').append(n);
                        }
                        s = i;
                        continue;
                    }
                    sb.append(replace, s, i + 1);
                    s = i + 1;
                }
                replace = sb.toString();
            }
        } else {
            replace = replace.replace("\\", "\\\\").replace("$", "\\$");
        }
        try {
            String replaced;
            Matcher m = regExpr.pattern.matcher(Token.string(value));
            if (action == null) {
                replaced = m.replaceAll(replace);
            } else {
                StringBuilder sb = new StringBuilder();
                while (m.find()) {
                    int gc = m.groupCount();
                    ValueBuilder groups = new ValueBuilder(qc);
                    for (int g = 0; g < gc; ++g) {
                        groups.add(Atm.get(m.group(g + 1)));
                    }
                    Item rplc = action.invoke(qc, this.info, Atm.get(m.group()), groups.value()).atomItem(qc, ii);
                    m.appendReplacement(sb, rplc.isEmpty() ? "" : Token.string(rplc.string(this.info)));
                }
                replaced = m.appendTail(sb).toString();
            }
            return Str.get(replaced);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("No group")) {
                Util.debug(ex);
                throw QueryError.REGEMPTY_X.get(this.info, new Object[]{pattern});
            }
            throw QueryError.REGINVALID_X.get(this.info, ex);
        }
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.HOF.in(flags) && this.defined(4) || super.has(flags);
    }
}

