/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.StandardFunc;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.db.Put;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnPut
extends StandardFunc {
    @Override
    public Empty item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode node = this.toNode(this.arg(0), qc);
        byte[] href = this.toZeroToken(this.arg(1), qc);
        Item options = this.arg(2).item(qc, this.info);
        if (!node.type.oneOf(NodeType.DOCUMENT_NODE, NodeType.ELEMENT)) {
            throw QueryError.UPFOTYPE_X.get(this.info, this.arg(0));
        }
        Uri uri = Uri.get(href);
        if (uri == Uri.EMPTY || !uri.isValid()) {
            throw QueryError.UPFOURI_X.get(this.info, new Object[]{href});
        }
        Updates updates = qc.updates();
        DBNode target = updates.determineDataRef(node, qc);
        String path = this.sc.resolve(Token.string(uri.string())).path();
        if (!updates.putPaths.add(path)) {
            throw QueryError.UPURIDUP_X.get(this.info, path);
        }
        SerializerOptions sopts = FuncOptions.serializer(options, this.info);
        updates.add(new Put(target.pre(), target.data(), path, sopts, this.info), qc);
        return Empty.VALUE;
    }
}

